package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ApproximateTotalCount, NextToken2500}
import scala.jdk.CollectionConverters._
final case class SearchQueuesResponse(
    queues: Optional[Iterable[zio.aws.connect.model.Queue]] = Optional.Absent,
    nextToken: Optional[NextToken2500] = Optional.Absent,
    approximateTotalCount: Optional[ApproximateTotalCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchQueuesResponse = {
    import SearchQueuesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchQueuesResponse
      .builder()
      .optionallyWith(
        queues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queues)
      .optionallyWith(
        nextToken.map(value => NextToken2500.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        approximateTotalCount.map(value =>
          ApproximateTotalCount.unwrap(value): java.lang.Long
        )
      )(_.approximateTotalCount)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SearchQueuesResponse.ReadOnly =
    zio.aws.connect.model.SearchQueuesResponse.wrap(buildAwsValue())
}
object SearchQueuesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchQueuesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchQueuesResponse =
      zio.aws.connect.model.SearchQueuesResponse(
        queues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        approximateTotalCount.map(value => value)
      )
    def queues: Optional[List[zio.aws.connect.model.Queue.ReadOnly]]
    def nextToken: Optional[NextToken2500]
    def approximateTotalCount: Optional[ApproximateTotalCount]
    def getQueues
        : ZIO[Any, AwsError, List[zio.aws.connect.model.Queue.ReadOnly]] =
      AwsError.unwrapOptionField("queues", queues)
    def getNextToken: ZIO[Any, AwsError, NextToken2500] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getApproximateTotalCount: ZIO[Any, AwsError, ApproximateTotalCount] =
      AwsError.unwrapOptionField("approximateTotalCount", approximateTotalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchQueuesResponse
  ) extends zio.aws.connect.model.SearchQueuesResponse.ReadOnly {
    override val queues: Optional[List[zio.aws.connect.model.Queue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.Queue.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken2500] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken2500(value))
    override val approximateTotalCount: Optional[ApproximateTotalCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approximateTotalCount())
        .map(value =>
          zio.aws.connect.model.primitives.ApproximateTotalCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchQueuesResponse
  ): zio.aws.connect.model.SearchQueuesResponse.ReadOnly = new Wrapper(impl)
}
