package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ApproximateTotalCount, NextToken2500}
import scala.jdk.CollectionConverters._
final case class SearchRoutingProfilesResponse(
    routingProfiles: Optional[Iterable[zio.aws.connect.model.RoutingProfile]] =
      Optional.Absent,
    nextToken: Optional[NextToken2500] = Optional.Absent,
    approximateTotalCount: Optional[ApproximateTotalCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchRoutingProfilesResponse = {
    import SearchRoutingProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchRoutingProfilesResponse
      .builder()
      .optionallyWith(
        routingProfiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routingProfiles)
      .optionallyWith(
        nextToken.map(value => NextToken2500.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        approximateTotalCount.map(value =>
          ApproximateTotalCount.unwrap(value): java.lang.Long
        )
      )(_.approximateTotalCount)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SearchRoutingProfilesResponse.ReadOnly =
    zio.aws.connect.model.SearchRoutingProfilesResponse.wrap(buildAwsValue())
}
object SearchRoutingProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchRoutingProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchRoutingProfilesResponse =
      zio.aws.connect.model.SearchRoutingProfilesResponse(
        routingProfiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        approximateTotalCount.map(value => value)
      )
    def routingProfiles
        : Optional[List[zio.aws.connect.model.RoutingProfile.ReadOnly]]
    def nextToken: Optional[NextToken2500]
    def approximateTotalCount: Optional[ApproximateTotalCount]
    def getRoutingProfiles: ZIO[Any, AwsError, List[
      zio.aws.connect.model.RoutingProfile.ReadOnly
    ]] = AwsError.unwrapOptionField("routingProfiles", routingProfiles)
    def getNextToken: ZIO[Any, AwsError, NextToken2500] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getApproximateTotalCount: ZIO[Any, AwsError, ApproximateTotalCount] =
      AwsError.unwrapOptionField("approximateTotalCount", approximateTotalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchRoutingProfilesResponse
  ) extends zio.aws.connect.model.SearchRoutingProfilesResponse.ReadOnly {
    override val routingProfiles
        : Optional[List[zio.aws.connect.model.RoutingProfile.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingProfiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.RoutingProfile.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken2500] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connect.model.primitives.NextToken2500(value))
    override val approximateTotalCount: Optional[ApproximateTotalCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approximateTotalCount())
        .map(value =>
          zio.aws.connect.model.primitives.ApproximateTotalCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchRoutingProfilesResponse
  ): zio.aws.connect.model.SearchRoutingProfilesResponse.ReadOnly = new Wrapper(
    impl
  )
}
