package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  VocabularyName,
  VocabularyNextToken,
  MaxResult100,
  InstanceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchVocabulariesRequest(
    instanceId: InstanceId,
    maxResults: Optional[MaxResult100] = Optional.Absent,
    nextToken: Optional[VocabularyNextToken] = Optional.Absent,
    state: Optional[zio.aws.connect.model.VocabularyState] = Optional.Absent,
    nameStartsWith: Optional[VocabularyName] = Optional.Absent,
    languageCode: Optional[zio.aws.connect.model.VocabularyLanguageCode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest = {
    import SearchVocabulariesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResult100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          VocabularyNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        nameStartsWith.map(value =>
          VocabularyName.unwrap(value): java.lang.String
        )
      )(_.nameStartsWith)
      .optionallyWith(languageCode.map(value => value.unwrap))(_.languageCode)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SearchVocabulariesRequest.ReadOnly =
    zio.aws.connect.model.SearchVocabulariesRequest.wrap(buildAwsValue())
}
object SearchVocabulariesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SearchVocabulariesRequest =
      zio.aws.connect.model.SearchVocabulariesRequest(
        instanceId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        state.map(value => value),
        nameStartsWith.map(value => value),
        languageCode.map(value => value)
      )
    def instanceId: InstanceId
    def maxResults: Optional[MaxResult100]
    def nextToken: Optional[VocabularyNextToken]
    def state: Optional[zio.aws.connect.model.VocabularyState]
    def nameStartsWith: Optional[VocabularyName]
    def languageCode: Optional[zio.aws.connect.model.VocabularyLanguageCode]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getMaxResults: ZIO[Any, AwsError, MaxResult100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, VocabularyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getState: ZIO[Any, AwsError, zio.aws.connect.model.VocabularyState] =
      AwsError.unwrapOptionField("state", state)
    def getNameStartsWith: ZIO[Any, AwsError, VocabularyName] =
      AwsError.unwrapOptionField("nameStartsWith", nameStartsWith)
    def getLanguageCode
        : ZIO[Any, AwsError, zio.aws.connect.model.VocabularyLanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest
  ) extends zio.aws.connect.model.SearchVocabulariesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val maxResults: Optional[MaxResult100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connect.model.primitives.MaxResult100(value))
    override val nextToken: Optional[VocabularyNextToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.connect.model.primitives.VocabularyNextToken(value)
        )
    override val state: Optional[zio.aws.connect.model.VocabularyState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.connect.model.VocabularyState.wrap(value))
    override val nameStartsWith: Optional[VocabularyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameStartsWith())
        .map(value => zio.aws.connect.model.primitives.VocabularyName(value))
    override val languageCode
        : Optional[zio.aws.connect.model.VocabularyLanguageCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.languageCode())
        .map(value => zio.aws.connect.model.VocabularyLanguageCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest
  ): zio.aws.connect.model.SearchVocabulariesRequest.ReadOnly = new Wrapper(
    impl
  )
}
