package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  SecurityProfileDescription,
  InstanceId,
  TagValue,
  SecurityProfileName,
  ARN,
  TagKey,
  SecurityProfileId
}
import scala.jdk.CollectionConverters._
final case class SecurityProfileSearchSummary(
    id: Optional[SecurityProfileId] = Optional.Absent,
    organizationResourceId: Optional[InstanceId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    securityProfileName: Optional[SecurityProfileName] = Optional.Absent,
    description: Optional[SecurityProfileDescription] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.SecurityProfileSearchSummary = {
    import SecurityProfileSearchSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.SecurityProfileSearchSummary
      .builder()
      .optionallyWith(
        id.map(value => SecurityProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        organizationResourceId.map(value =>
          InstanceId.unwrap(value): java.lang.String
        )
      )(_.organizationResourceId)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        securityProfileName.map(value =>
          SecurityProfileName.unwrap(value): java.lang.String
        )
      )(_.securityProfileName)
      .optionallyWith(
        description.map(value =>
          SecurityProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.SecurityProfileSearchSummary.ReadOnly =
    zio.aws.connect.model.SecurityProfileSearchSummary.wrap(buildAwsValue())
}
object SecurityProfileSearchSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.SecurityProfileSearchSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.SecurityProfileSearchSummary =
      zio.aws.connect.model.SecurityProfileSearchSummary(
        id.map(value => value),
        organizationResourceId.map(value => value),
        arn.map(value => value),
        securityProfileName.map(value => value),
        description.map(value => value),
        tags.map(value => value)
      )
    def id: Optional[SecurityProfileId]
    def organizationResourceId: Optional[InstanceId]
    def arn: Optional[ARN]
    def securityProfileName: Optional[SecurityProfileName]
    def description: Optional[SecurityProfileDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def getId: ZIO[Any, AwsError, SecurityProfileId] =
      AwsError.unwrapOptionField("id", id)
    def getOrganizationResourceId: ZIO[Any, AwsError, InstanceId] = AwsError
      .unwrapOptionField("organizationResourceId", organizationResourceId)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getSecurityProfileName: ZIO[Any, AwsError, SecurityProfileName] =
      AwsError.unwrapOptionField("securityProfileName", securityProfileName)
    def getDescription: ZIO[Any, AwsError, SecurityProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.SecurityProfileSearchSummary
  ) extends zio.aws.connect.model.SecurityProfileSearchSummary.ReadOnly {
    override val id: Optional[SecurityProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.SecurityProfileId(value))
    override val organizationResourceId: Optional[InstanceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationResourceId())
        .map(value => zio.aws.connect.model.primitives.InstanceId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val securityProfileName: Optional[SecurityProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProfileName())
        .map(value =>
          zio.aws.connect.model.primitives.SecurityProfileName(value)
        )
    override val description: Optional[SecurityProfileDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.SecurityProfileDescription(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.SecurityProfileSearchSummary
  ): zio.aws.connect.model.SecurityProfileSearchSummary.ReadOnly = new Wrapper(
    impl
  )
}
