package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait SourceType {
  def unwrap: software.amazon.awssdk.services.connect.model.SourceType
}
object SourceType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.SourceType
  ): zio.aws.connect.model.SourceType = value match {
    case software.amazon.awssdk.services.connect.model.SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.SourceType.SALESFORCE =>
      val r = SALESFORCE
      r
    case software.amazon.awssdk.services.connect.model.SourceType.ZENDESK =>
      val r = ZENDESK
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.SourceType =
      software.amazon.awssdk.services.connect.model.SourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object SALESFORCE extends zio.aws.connect.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.SourceType =
      software.amazon.awssdk.services.connect.model.SourceType.SALESFORCE
  }
  case object ZENDESK extends zio.aws.connect.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.SourceType =
      software.amazon.awssdk.services.connect.model.SourceType.ZENDESK
  }
}
