package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  ParticipantToken,
  ParticipantId,
  ContactId
}
import scala.jdk.CollectionConverters._
final case class StartChatContactResponse(
    contactId: Optional[ContactId] = Optional.Absent,
    participantId: Optional[ParticipantId] = Optional.Absent,
    participantToken: Optional[ParticipantToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StartChatContactResponse = {
    import StartChatContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StartChatContactResponse
      .builder()
      .optionallyWith(
        contactId.map(value => ContactId.unwrap(value): java.lang.String)
      )(_.contactId)
      .optionallyWith(
        participantId.map(value =>
          ParticipantId.unwrap(value): java.lang.String
        )
      )(_.participantId)
      .optionallyWith(
        participantToken.map(value =>
          ParticipantToken.unwrap(value): java.lang.String
        )
      )(_.participantToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.StartChatContactResponse.ReadOnly =
    zio.aws.connect.model.StartChatContactResponse.wrap(buildAwsValue())
}
object StartChatContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StartChatContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StartChatContactResponse =
      zio.aws.connect.model.StartChatContactResponse(
        contactId.map(value => value),
        participantId.map(value => value),
        participantToken.map(value => value)
      )
    def contactId: Optional[ContactId]
    def participantId: Optional[ParticipantId]
    def participantToken: Optional[ParticipantToken]
    def getContactId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("contactId", contactId)
    def getParticipantId: ZIO[Any, AwsError, ParticipantId] =
      AwsError.unwrapOptionField("participantId", participantId)
    def getParticipantToken: ZIO[Any, AwsError, ParticipantToken] =
      AwsError.unwrapOptionField("participantToken", participantToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StartChatContactResponse
  ) extends zio.aws.connect.model.StartChatContactResponse.ReadOnly {
    override val contactId: Optional[ContactId] = zio.aws.core.internal
      .optionalFromNullable(impl.contactId())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
    override val participantId: Optional[ParticipantId] = zio.aws.core.internal
      .optionalFromNullable(impl.participantId())
      .map(value => zio.aws.connect.model.primitives.ParticipantId(value))
    override val participantToken: Optional[ParticipantToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participantToken())
        .map(value => zio.aws.connect.model.primitives.ParticipantToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StartChatContactResponse
  ): zio.aws.connect.model.StartChatContactResponse.ReadOnly = new Wrapper(impl)
}
