package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  QueueId,
  CampaignId,
  AttributeName,
  InstanceId,
  PhoneNumber,
  ClientToken,
  ContactFlowId,
  AttributeValue
}
import scala.jdk.CollectionConverters._
final case class StartOutboundVoiceContactRequest(
    destinationPhoneNumber: PhoneNumber,
    contactFlowId: ContactFlowId,
    instanceId: InstanceId,
    clientToken: Optional[ClientToken] = Optional.Absent,
    sourcePhoneNumber: Optional[PhoneNumber] = Optional.Absent,
    queueId: Optional[QueueId] = Optional.Absent,
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent,
    answerMachineDetectionConfig: Optional[
      zio.aws.connect.model.AnswerMachineDetectionConfig
    ] = Optional.Absent,
    campaignId: Optional[CampaignId] = Optional.Absent,
    trafficType: Optional[zio.aws.connect.model.TrafficType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactRequest = {
    import StartOutboundVoiceContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactRequest
      .builder()
      .destinationPhoneNumber(
        PhoneNumber.unwrap(destinationPhoneNumber): java.lang.String
      )
      .contactFlowId(ContactFlowId.unwrap(contactFlowId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        sourcePhoneNumber.map(value =>
          PhoneNumber.unwrap(value): java.lang.String
        )
      )(_.sourcePhoneNumber)
      .optionallyWith(
        queueId.map(value => QueueId.unwrap(value): java.lang.String)
      )(_.queueId)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        answerMachineDetectionConfig.map(value => value.buildAwsValue())
      )(_.answerMachineDetectionConfig)
      .optionallyWith(
        campaignId.map(value => CampaignId.unwrap(value): java.lang.String)
      )(_.campaignId)
      .optionallyWith(trafficType.map(value => value.unwrap))(_.trafficType)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.StartOutboundVoiceContactRequest.ReadOnly =
    zio.aws.connect.model.StartOutboundVoiceContactRequest.wrap(buildAwsValue())
}
object StartOutboundVoiceContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StartOutboundVoiceContactRequest =
      zio.aws.connect.model.StartOutboundVoiceContactRequest(
        destinationPhoneNumber,
        contactFlowId,
        instanceId,
        clientToken.map(value => value),
        sourcePhoneNumber.map(value => value),
        queueId.map(value => value),
        attributes.map(value => value),
        answerMachineDetectionConfig.map(value => value.asEditable),
        campaignId.map(value => value),
        trafficType.map(value => value)
      )
    def destinationPhoneNumber: PhoneNumber
    def contactFlowId: ContactFlowId
    def instanceId: InstanceId
    def clientToken: Optional[ClientToken]
    def sourcePhoneNumber: Optional[PhoneNumber]
    def queueId: Optional[QueueId]
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def answerMachineDetectionConfig
        : Optional[zio.aws.connect.model.AnswerMachineDetectionConfig.ReadOnly]
    def campaignId: Optional[CampaignId]
    def trafficType: Optional[zio.aws.connect.model.TrafficType]
    def getDestinationPhoneNumber: ZIO[Any, Nothing, PhoneNumber] =
      ZIO.succeed(destinationPhoneNumber)
    def getContactFlowId: ZIO[Any, Nothing, ContactFlowId] =
      ZIO.succeed(contactFlowId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSourcePhoneNumber: ZIO[Any, AwsError, PhoneNumber] =
      AwsError.unwrapOptionField("sourcePhoneNumber", sourcePhoneNumber)
    def getQueueId: ZIO[Any, AwsError, QueueId] =
      AwsError.unwrapOptionField("queueId", queueId)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getAnswerMachineDetectionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.AnswerMachineDetectionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "answerMachineDetectionConfig",
      answerMachineDetectionConfig
    )
    def getCampaignId: ZIO[Any, AwsError, CampaignId] =
      AwsError.unwrapOptionField("campaignId", campaignId)
    def getTrafficType: ZIO[Any, AwsError, zio.aws.connect.model.TrafficType] =
      AwsError.unwrapOptionField("trafficType", trafficType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactRequest
  ) extends zio.aws.connect.model.StartOutboundVoiceContactRequest.ReadOnly {
    override val destinationPhoneNumber: PhoneNumber =
      zio.aws.connect.model.primitives
        .PhoneNumber(impl.destinationPhoneNumber())
    override val contactFlowId: ContactFlowId =
      zio.aws.connect.model.primitives.ContactFlowId(impl.contactFlowId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
    override val sourcePhoneNumber: Optional[PhoneNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourcePhoneNumber())
        .map(value => zio.aws.connect.model.primitives.PhoneNumber(value))
    override val queueId: Optional[QueueId] = zio.aws.core.internal
      .optionalFromNullable(impl.queueId())
      .map(value => zio.aws.connect.model.primitives.QueueId(value))
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.connect.model.primitives.AttributeName(
                key
              ) -> zio.aws.connect.model.primitives.AttributeValue(value)
            })
            .toMap
        )
    override val answerMachineDetectionConfig: Optional[
      zio.aws.connect.model.AnswerMachineDetectionConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.answerMachineDetectionConfig())
      .map(value =>
        zio.aws.connect.model.AnswerMachineDetectionConfig.wrap(value)
      )
    override val campaignId: Optional[CampaignId] = zio.aws.core.internal
      .optionalFromNullable(impl.campaignId())
      .map(value => zio.aws.connect.model.primitives.CampaignId(value))
    override val trafficType: Optional[zio.aws.connect.model.TrafficType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficType())
        .map(value => zio.aws.connect.model.TrafficType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactRequest
  ): zio.aws.connect.model.StartOutboundVoiceContactRequest.ReadOnly =
    new Wrapper(impl)
}
