package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  QuickConnectId,
  AttributeName,
  InstanceId,
  Timestamp,
  ReferenceKey,
  Description,
  ContactId,
  ClientToken,
  TaskTemplateId,
  ContactFlowId,
  Name,
  AttributeValue
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class StartTaskContactRequest(
    instanceId: InstanceId,
    previousContactId: Optional[ContactId] = Optional.Absent,
    contactFlowId: Optional[ContactFlowId] = Optional.Absent,
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent,
    name: Name,
    references: Optional[Map[ReferenceKey, zio.aws.connect.model.Reference]] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    scheduledTime: Optional[Timestamp] = Optional.Absent,
    taskTemplateId: Optional[TaskTemplateId] = Optional.Absent,
    quickConnectId: Optional[QuickConnectId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StartTaskContactRequest = {
    import StartTaskContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StartTaskContactRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        previousContactId.map(value =>
          ContactId.unwrap(value): java.lang.String
        )
      )(_.previousContactId)
      .optionallyWith(
        contactFlowId.map(value =>
          ContactFlowId.unwrap(value): java.lang.String
        )
      )(_.contactFlowId)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        references.map(value =>
          value
            .map({ case (key, value) =>
              (ReferenceKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.references)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        scheduledTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledTime)
      .optionallyWith(
        taskTemplateId.map(value =>
          TaskTemplateId.unwrap(value): java.lang.String
        )
      )(_.taskTemplateId)
      .optionallyWith(
        quickConnectId.map(value =>
          QuickConnectId.unwrap(value): java.lang.String
        )
      )(_.quickConnectId)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.StartTaskContactRequest.ReadOnly =
    zio.aws.connect.model.StartTaskContactRequest.wrap(buildAwsValue())
}
object StartTaskContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StartTaskContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StartTaskContactRequest =
      zio.aws.connect.model.StartTaskContactRequest(
        instanceId,
        previousContactId.map(value => value),
        contactFlowId.map(value => value),
        attributes.map(value => value),
        name,
        references.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        description.map(value => value),
        clientToken.map(value => value),
        scheduledTime.map(value => value),
        taskTemplateId.map(value => value),
        quickConnectId.map(value => value)
      )
    def instanceId: InstanceId
    def previousContactId: Optional[ContactId]
    def contactFlowId: Optional[ContactFlowId]
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def name: Name
    def references
        : Optional[Map[ReferenceKey, zio.aws.connect.model.Reference.ReadOnly]]
    def description: Optional[Description]
    def clientToken: Optional[ClientToken]
    def scheduledTime: Optional[Timestamp]
    def taskTemplateId: Optional[TaskTemplateId]
    def quickConnectId: Optional[QuickConnectId]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getPreviousContactId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("previousContactId", previousContactId)
    def getContactFlowId: ZIO[Any, AwsError, ContactFlowId] =
      AwsError.unwrapOptionField("contactFlowId", contactFlowId)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getReferences: ZIO[Any, AwsError, Map[
      ReferenceKey,
      zio.aws.connect.model.Reference.ReadOnly
    ]] = AwsError.unwrapOptionField("references", references)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getScheduledTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledTime", scheduledTime)
    def getTaskTemplateId: ZIO[Any, AwsError, TaskTemplateId] =
      AwsError.unwrapOptionField("taskTemplateId", taskTemplateId)
    def getQuickConnectId: ZIO[Any, AwsError, QuickConnectId] =
      AwsError.unwrapOptionField("quickConnectId", quickConnectId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StartTaskContactRequest
  ) extends zio.aws.connect.model.StartTaskContactRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val previousContactId: Optional[ContactId] = zio.aws.core.internal
      .optionalFromNullable(impl.previousContactId())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
    override val contactFlowId: Optional[ContactFlowId] = zio.aws.core.internal
      .optionalFromNullable(impl.contactFlowId())
      .map(value => zio.aws.connect.model.primitives.ContactFlowId(value))
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.connect.model.primitives.AttributeName(
                key
              ) -> zio.aws.connect.model.primitives.AttributeValue(value)
            })
            .toMap
        )
    override val name: Name = zio.aws.connect.model.primitives.Name(impl.name())
    override val references: Optional[
      Map[ReferenceKey, zio.aws.connect.model.Reference.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.references())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .ReferenceKey(key) -> zio.aws.connect.model.Reference.wrap(value)
          })
          .toMap
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.connect.model.primitives.Description(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
    override val scheduledTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val taskTemplateId: Optional[TaskTemplateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskTemplateId())
        .map(value => zio.aws.connect.model.primitives.TaskTemplateId(value))
    override val quickConnectId: Optional[QuickConnectId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quickConnectId())
        .map(value => zio.aws.connect.model.primitives.QuickConnectId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StartTaskContactRequest
  ): zio.aws.connect.model.StartTaskContactRequest.ReadOnly = new Wrapper(impl)
}
