package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{InstanceId, ContactId}
import scala.jdk.CollectionConverters._
final case class StopContactRequest(
    contactId: ContactId,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StopContactRequest = {
    import StopContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StopContactRequest
      .builder()
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.StopContactRequest.ReadOnly =
    zio.aws.connect.model.StopContactRequest.wrap(buildAwsValue())
}
object StopContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StopContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StopContactRequest =
      zio.aws.connect.model.StopContactRequest(contactId, instanceId)
    def contactId: ContactId
    def instanceId: InstanceId
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StopContactRequest
  ) extends zio.aws.connect.model.StopContactRequest.ReadOnly {
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StopContactRequest
  ): zio.aws.connect.model.StopContactRequest.ReadOnly = new Wrapper(impl)
}
