package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StringCondition(
    fieldName: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    comparisonType: Optional[zio.aws.connect.model.StringComparisonType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.StringCondition = {
    import StringCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.StringCondition
      .builder()
      .optionallyWith(fieldName.map(value => value: java.lang.String))(
        _.fieldName
      )
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(comparisonType.map(value => value.unwrap))(
        _.comparisonType
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.StringCondition.ReadOnly =
    zio.aws.connect.model.StringCondition.wrap(buildAwsValue())
}
object StringCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.StringCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.StringCondition =
      zio.aws.connect.model.StringCondition(
        fieldName.map(value => value),
        value.map(value => value),
        comparisonType.map(value => value)
      )
    def fieldName: Optional[String]
    def value: Optional[String]
    def comparisonType: Optional[zio.aws.connect.model.StringComparisonType]
    def getFieldName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fieldName", fieldName)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getComparisonType
        : ZIO[Any, AwsError, zio.aws.connect.model.StringComparisonType] =
      AwsError.unwrapOptionField("comparisonType", comparisonType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.StringCondition
  ) extends zio.aws.connect.model.StringCondition.ReadOnly {
    override val fieldName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldName())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val comparisonType
        : Optional[zio.aws.connect.model.StringComparisonType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comparisonType())
        .map(value => zio.aws.connect.model.StringComparisonType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.StringCondition
  ): zio.aws.connect.model.StringCondition.ReadOnly = new Wrapper(impl)
}
