package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TaskTemplateConstraints(
    requiredFields: Optional[
      Iterable[zio.aws.connect.model.RequiredFieldInfo]
    ] = Optional.Absent,
    readOnlyFields: Optional[
      Iterable[zio.aws.connect.model.ReadOnlyFieldInfo]
    ] = Optional.Absent,
    invisibleFields: Optional[
      Iterable[zio.aws.connect.model.InvisibleFieldInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TaskTemplateConstraints = {
    import TaskTemplateConstraints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TaskTemplateConstraints
      .builder()
      .optionallyWith(
        requiredFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requiredFields)
      .optionallyWith(
        readOnlyFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.readOnlyFields)
      .optionallyWith(
        invisibleFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.invisibleFields)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.TaskTemplateConstraints.ReadOnly =
    zio.aws.connect.model.TaskTemplateConstraints.wrap(buildAwsValue())
}
object TaskTemplateConstraints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TaskTemplateConstraints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TaskTemplateConstraints =
      zio.aws.connect.model.TaskTemplateConstraints(
        requiredFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        readOnlyFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        invisibleFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def requiredFields
        : Optional[List[zio.aws.connect.model.RequiredFieldInfo.ReadOnly]]
    def readOnlyFields
        : Optional[List[zio.aws.connect.model.ReadOnlyFieldInfo.ReadOnly]]
    def invisibleFields
        : Optional[List[zio.aws.connect.model.InvisibleFieldInfo.ReadOnly]]
    def getRequiredFields: ZIO[Any, AwsError, List[
      zio.aws.connect.model.RequiredFieldInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("requiredFields", requiredFields)
    def getReadOnlyFields: ZIO[Any, AwsError, List[
      zio.aws.connect.model.ReadOnlyFieldInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("readOnlyFields", readOnlyFields)
    def getInvisibleFields: ZIO[Any, AwsError, List[
      zio.aws.connect.model.InvisibleFieldInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("invisibleFields", invisibleFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TaskTemplateConstraints
  ) extends zio.aws.connect.model.TaskTemplateConstraints.ReadOnly {
    override val requiredFields
        : Optional[List[zio.aws.connect.model.RequiredFieldInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiredFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.RequiredFieldInfo.wrap(item)
          }.toList
        )
    override val readOnlyFields
        : Optional[List[zio.aws.connect.model.ReadOnlyFieldInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readOnlyFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.ReadOnlyFieldInfo.wrap(item)
          }.toList
        )
    override val invisibleFields
        : Optional[List[zio.aws.connect.model.InvisibleFieldInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invisibleFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.InvisibleFieldInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TaskTemplateConstraints
  ): zio.aws.connect.model.TaskTemplateConstraints.ReadOnly = new Wrapper(impl)
}
