package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.TaskTemplateFieldValue
import scala.jdk.CollectionConverters._
final case class TaskTemplateDefaultFieldValue(
    id: Optional[zio.aws.connect.model.TaskTemplateFieldIdentifier] =
      Optional.Absent,
    defaultValue: Optional[TaskTemplateFieldValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TaskTemplateDefaultFieldValue = {
    import TaskTemplateDefaultFieldValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TaskTemplateDefaultFieldValue
      .builder()
      .optionallyWith(id.map(value => value.buildAwsValue()))(_.id)
      .optionallyWith(
        defaultValue.map(value =>
          TaskTemplateFieldValue.unwrap(value): java.lang.String
        )
      )(_.defaultValue)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.TaskTemplateDefaultFieldValue.ReadOnly =
    zio.aws.connect.model.TaskTemplateDefaultFieldValue.wrap(buildAwsValue())
}
object TaskTemplateDefaultFieldValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TaskTemplateDefaultFieldValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TaskTemplateDefaultFieldValue =
      zio.aws.connect.model.TaskTemplateDefaultFieldValue(
        id.map(value => value.asEditable),
        defaultValue.map(value => value)
      )
    def id: Optional[zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly]
    def defaultValue: Optional[TaskTemplateFieldValue]
    def getId: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField("id", id)
    def getDefaultValue: ZIO[Any, AwsError, TaskTemplateFieldValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TaskTemplateDefaultFieldValue
  ) extends zio.aws.connect.model.TaskTemplateDefaultFieldValue.ReadOnly {
    override val id
        : Optional[zio.aws.connect.model.TaskTemplateFieldIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.connect.model.TaskTemplateFieldIdentifier.wrap(value)
        )
    override val defaultValue: Optional[TaskTemplateFieldValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultValue())
        .map(value =>
          zio.aws.connect.model.primitives.TaskTemplateFieldValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TaskTemplateDefaultFieldValue
  ): zio.aws.connect.model.TaskTemplateDefaultFieldValue.ReadOnly = new Wrapper(
    impl
  )
}
