package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TaskTemplateDefaults(
    defaultFieldValues: Optional[
      Iterable[zio.aws.connect.model.TaskTemplateDefaultFieldValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TaskTemplateDefaults = {
    import TaskTemplateDefaults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TaskTemplateDefaults
      .builder()
      .optionallyWith(
        defaultFieldValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultFieldValues)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.TaskTemplateDefaults.ReadOnly =
    zio.aws.connect.model.TaskTemplateDefaults.wrap(buildAwsValue())
}
object TaskTemplateDefaults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TaskTemplateDefaults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TaskTemplateDefaults =
      zio.aws.connect.model.TaskTemplateDefaults(
        defaultFieldValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def defaultFieldValues: Optional[
      List[zio.aws.connect.model.TaskTemplateDefaultFieldValue.ReadOnly]
    ]
    def getDefaultFieldValues: ZIO[Any, AwsError, List[
      zio.aws.connect.model.TaskTemplateDefaultFieldValue.ReadOnly
    ]] = AwsError.unwrapOptionField("defaultFieldValues", defaultFieldValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TaskTemplateDefaults
  ) extends zio.aws.connect.model.TaskTemplateDefaults.ReadOnly {
    override val defaultFieldValues: Optional[
      List[zio.aws.connect.model.TaskTemplateDefaultFieldValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultFieldValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.TaskTemplateDefaultFieldValue.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TaskTemplateDefaults
  ): zio.aws.connect.model.TaskTemplateDefaults.ReadOnly = new Wrapper(impl)
}
