package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait TaskTemplateStatus {
  def unwrap: software.amazon.awssdk.services.connect.model.TaskTemplateStatus
}
object TaskTemplateStatus {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.TaskTemplateStatus
  ): zio.aws.connect.model.TaskTemplateStatus = value match {
    case software.amazon.awssdk.services.connect.model.TaskTemplateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.TaskTemplateStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.connect.model.TaskTemplateStatus.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.TaskTemplateStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.TaskTemplateStatus =
      software.amazon.awssdk.services.connect.model.TaskTemplateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.connect.model.TaskTemplateStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.TaskTemplateStatus =
      software.amazon.awssdk.services.connect.model.TaskTemplateStatus.ACTIVE
  }
  case object INACTIVE extends zio.aws.connect.model.TaskTemplateStatus {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.TaskTemplateStatus =
      software.amazon.awssdk.services.connect.model.TaskTemplateStatus.INACTIVE
  }
}
