package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.ThresholdValue
import scala.jdk.CollectionConverters._
final case class Threshold(
    comparison: Optional[zio.aws.connect.model.Comparison] = Optional.Absent,
    thresholdValue: Optional[ThresholdValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.Threshold = {
    import Threshold.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Threshold
      .builder()
      .optionallyWith(comparison.map(value => value.unwrap))(_.comparison)
      .optionallyWith(
        thresholdValue.map(value =>
          ThresholdValue.unwrap(value): java.lang.Double
        )
      )(_.thresholdValue)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Threshold.ReadOnly =
    zio.aws.connect.model.Threshold.wrap(buildAwsValue())
}
object Threshold {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.Threshold] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Threshold =
      zio.aws.connect.model.Threshold(
        comparison.map(value => value),
        thresholdValue.map(value => value)
      )
    def comparison: Optional[zio.aws.connect.model.Comparison]
    def thresholdValue: Optional[ThresholdValue]
    def getComparison: ZIO[Any, AwsError, zio.aws.connect.model.Comparison] =
      AwsError.unwrapOptionField("comparison", comparison)
    def getThresholdValue: ZIO[Any, AwsError, ThresholdValue] =
      AwsError.unwrapOptionField("thresholdValue", thresholdValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Threshold
  ) extends zio.aws.connect.model.Threshold.ReadOnly {
    override val comparison: Optional[zio.aws.connect.model.Comparison] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comparison())
        .map(value => zio.aws.connect.model.Comparison.wrap(value))
    override val thresholdValue: Optional[ThresholdValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thresholdValue())
        .map(value => zio.aws.connect.model.primitives.ThresholdValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Threshold
  ): zio.aws.connect.model.Threshold.ReadOnly = new Wrapper(impl)
}
