package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  InstanceArn,
  Name128,
  TrafficDistributionGroupArn,
  TrafficDistributionGroupId
}
import scala.jdk.CollectionConverters._
final case class TrafficDistributionGroupSummary(
    id: Optional[TrafficDistributionGroupId] = Optional.Absent,
    arn: Optional[TrafficDistributionGroupArn] = Optional.Absent,
    name: Optional[Name128] = Optional.Absent,
    instanceArn: Optional[InstanceArn] = Optional.Absent,
    status: Optional[zio.aws.connect.model.TrafficDistributionGroupStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TrafficDistributionGroupSummary = {
    import TrafficDistributionGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TrafficDistributionGroupSummary
      .builder()
      .optionallyWith(
        id.map(value =>
          TrafficDistributionGroupId.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(
        arn.map(value =>
          TrafficDistributionGroupArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(
        name.map(value => Name128.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        instanceArn.map(value => InstanceArn.unwrap(value): java.lang.String)
      )(_.instanceArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.TrafficDistributionGroupSummary.ReadOnly =
    zio.aws.connect.model.TrafficDistributionGroupSummary.wrap(buildAwsValue())
}
object TrafficDistributionGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TrafficDistributionGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TrafficDistributionGroupSummary =
      zio.aws.connect.model.TrafficDistributionGroupSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        instanceArn.map(value => value),
        status.map(value => value)
      )
    def id: Optional[TrafficDistributionGroupId]
    def arn: Optional[TrafficDistributionGroupArn]
    def name: Optional[Name128]
    def instanceArn: Optional[InstanceArn]
    def status: Optional[zio.aws.connect.model.TrafficDistributionGroupStatus]
    def getId: ZIO[Any, AwsError, TrafficDistributionGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, TrafficDistributionGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name128] =
      AwsError.unwrapOptionField("name", name)
    def getInstanceArn: ZIO[Any, AwsError, InstanceArn] =
      AwsError.unwrapOptionField("instanceArn", instanceArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TrafficDistributionGroupStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TrafficDistributionGroupSummary
  ) extends zio.aws.connect.model.TrafficDistributionGroupSummary.ReadOnly {
    override val id: Optional[TrafficDistributionGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.connect.model.primitives.TrafficDistributionGroupId(value)
        )
    override val arn: Optional[TrafficDistributionGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.connect.model.primitives.TrafficDistributionGroupArn(value)
        )
    override val name: Optional[Name128] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.Name128(value))
    override val instanceArn: Optional[InstanceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceArn())
      .map(value => zio.aws.connect.model.primitives.InstanceArn(value))
    override val status
        : Optional[zio.aws.connect.model.TrafficDistributionGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.connect.model.TrafficDistributionGroupStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TrafficDistributionGroupSummary
  ): zio.aws.connect.model.TrafficDistributionGroupSummary.ReadOnly =
    new Wrapper(impl)
}
