package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait TrafficType {
  def unwrap: software.amazon.awssdk.services.connect.model.TrafficType
}
object TrafficType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.TrafficType
  ): zio.aws.connect.model.TrafficType = value match {
    case software.amazon.awssdk.services.connect.model.TrafficType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.TrafficType.GENERAL =>
      val r = GENERAL
      r
    case software.amazon.awssdk.services.connect.model.TrafficType.CAMPAIGN =>
      val r = CAMPAIGN
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.TrafficType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.TrafficType =
      software.amazon.awssdk.services.connect.model.TrafficType.UNKNOWN_TO_SDK_VERSION
  }
  case object GENERAL extends zio.aws.connect.model.TrafficType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.TrafficType =
      software.amazon.awssdk.services.connect.model.TrafficType.GENERAL
  }
  case object CAMPAIGN extends zio.aws.connect.model.TrafficType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.TrafficType =
      software.amazon.awssdk.services.connect.model.TrafficType.CAMPAIGN
  }
}
