package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ARN, ContactId}
import scala.jdk.CollectionConverters._
final case class TransferContactResponse(
    contactId: Optional[ContactId] = Optional.Absent,
    contactArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.TransferContactResponse = {
    import TransferContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.TransferContactResponse
      .builder()
      .optionallyWith(
        contactId.map(value => ContactId.unwrap(value): java.lang.String)
      )(_.contactId)
      .optionallyWith(
        contactArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.contactArn)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.TransferContactResponse.ReadOnly =
    zio.aws.connect.model.TransferContactResponse.wrap(buildAwsValue())
}
object TransferContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.TransferContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.TransferContactResponse =
      zio.aws.connect.model.TransferContactResponse(
        contactId.map(value => value),
        contactArn.map(value => value)
      )
    def contactId: Optional[ContactId]
    def contactArn: Optional[ARN]
    def getContactId: ZIO[Any, AwsError, ContactId] =
      AwsError.unwrapOptionField("contactId", contactId)
    def getContactArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("contactArn", contactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.TransferContactResponse
  ) extends zio.aws.connect.model.TransferContactResponse.ReadOnly {
    override val contactId: Optional[ContactId] = zio.aws.core.internal
      .optionalFromNullable(impl.contactId())
      .map(value => zio.aws.connect.model.primitives.ContactId(value))
    override val contactArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.contactArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.TransferContactResponse
  ): zio.aws.connect.model.TransferContactResponse.ReadOnly = new Wrapper(impl)
}
