package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  InstanceId,
  AgentStatusId,
  UpdateAgentStatusDescription,
  AgentStatusName,
  AgentStatusOrderNumber
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateAgentStatusRequest(
    instanceId: InstanceId,
    agentStatusId: AgentStatusId,
    name: Optional[AgentStatusName] = Optional.Absent,
    description: Optional[UpdateAgentStatusDescription] = Optional.Absent,
    state: Optional[zio.aws.connect.model.AgentStatusState] = Optional.Absent,
    displayOrder: Optional[AgentStatusOrderNumber] = Optional.Absent,
    resetOrderNumber: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateAgentStatusRequest = {
    import UpdateAgentStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateAgentStatusRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .agentStatusId(AgentStatusId.unwrap(agentStatusId): java.lang.String)
      .optionallyWith(
        name.map(value => AgentStatusName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          UpdateAgentStatusDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        displayOrder.map(value => AgentStatusOrderNumber.unwrap(value): Integer)
      )(_.displayOrder)
      .optionallyWith(resetOrderNumber.map(value => value: java.lang.Boolean))(
        _.resetOrderNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateAgentStatusRequest.ReadOnly =
    zio.aws.connect.model.UpdateAgentStatusRequest.wrap(buildAwsValue())
}
object UpdateAgentStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateAgentStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateAgentStatusRequest =
      zio.aws.connect.model.UpdateAgentStatusRequest(
        instanceId,
        agentStatusId,
        name.map(value => value),
        description.map(value => value),
        state.map(value => value),
        displayOrder.map(value => value),
        resetOrderNumber.map(value => value)
      )
    def instanceId: InstanceId
    def agentStatusId: AgentStatusId
    def name: Optional[AgentStatusName]
    def description: Optional[UpdateAgentStatusDescription]
    def state: Optional[zio.aws.connect.model.AgentStatusState]
    def displayOrder: Optional[AgentStatusOrderNumber]
    def resetOrderNumber: Optional[Boolean]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getAgentStatusId: ZIO[Any, Nothing, AgentStatusId] =
      ZIO.succeed(agentStatusId)
    def getName: ZIO[Any, AwsError, AgentStatusName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, UpdateAgentStatusDescription] =
      AwsError.unwrapOptionField("description", description)
    def getState: ZIO[Any, AwsError, zio.aws.connect.model.AgentStatusState] =
      AwsError.unwrapOptionField("state", state)
    def getDisplayOrder: ZIO[Any, AwsError, AgentStatusOrderNumber] =
      AwsError.unwrapOptionField("displayOrder", displayOrder)
    def getResetOrderNumber: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("resetOrderNumber", resetOrderNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateAgentStatusRequest
  ) extends zio.aws.connect.model.UpdateAgentStatusRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val agentStatusId: AgentStatusId =
      zio.aws.connect.model.primitives.AgentStatusId(impl.agentStatusId())
    override val name: Optional[AgentStatusName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.AgentStatusName(value))
    override val description: Optional[UpdateAgentStatusDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.UpdateAgentStatusDescription(value)
        )
    override val state: Optional[zio.aws.connect.model.AgentStatusState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.connect.model.AgentStatusState.wrap(value))
    override val displayOrder: Optional[AgentStatusOrderNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayOrder())
        .map(value =>
          zio.aws.connect.model.primitives.AgentStatusOrderNumber(value)
        )
    override val resetOrderNumber: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.resetOrderNumber())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateAgentStatusRequest
  ): zio.aws.connect.model.UpdateAgentStatusRequest.ReadOnly = new Wrapper(impl)
}
