package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{
  ContactFlowModuleContent,
  ContactFlowModuleId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class UpdateContactFlowModuleContentRequest(
    instanceId: InstanceId,
    contactFlowModuleId: ContactFlowModuleId,
    content: ContactFlowModuleContent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleContentRequest = {
    import UpdateContactFlowModuleContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleContentRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactFlowModuleId(
        ContactFlowModuleId.unwrap(contactFlowModuleId): java.lang.String
      )
      .content(ContactFlowModuleContent.unwrap(content): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateContactFlowModuleContentRequest.ReadOnly =
    zio.aws.connect.model.UpdateContactFlowModuleContentRequest
      .wrap(buildAwsValue())
}
object UpdateContactFlowModuleContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.UpdateContactFlowModuleContentRequest =
      zio.aws.connect.model.UpdateContactFlowModuleContentRequest(
        instanceId,
        contactFlowModuleId,
        content
      )
    def instanceId: InstanceId
    def contactFlowModuleId: ContactFlowModuleId
    def content: ContactFlowModuleContent
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactFlowModuleId: ZIO[Any, Nothing, ContactFlowModuleId] =
      ZIO.succeed(contactFlowModuleId)
    def getContent: ZIO[Any, Nothing, ContactFlowModuleContent] =
      ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleContentRequest
  ) extends zio.aws.connect.model.UpdateContactFlowModuleContentRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactFlowModuleId: ContactFlowModuleId =
      zio.aws.connect.model.primitives
        .ContactFlowModuleId(impl.contactFlowModuleId())
    override val content: ContactFlowModuleContent =
      zio.aws.connect.model.primitives.ContactFlowModuleContent(impl.content())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleContentRequest
  ): zio.aws.connect.model.UpdateContactFlowModuleContentRequest.ReadOnly =
    new Wrapper(impl)
}
