package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ARN, PhoneNumberId}
import scala.jdk.CollectionConverters._
final case class UpdatePhoneNumberResponse(
    phoneNumberId: Optional[PhoneNumberId] = Optional.Absent,
    phoneNumberArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdatePhoneNumberResponse = {
    import UpdatePhoneNumberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdatePhoneNumberResponse
      .builder()
      .optionallyWith(
        phoneNumberId.map(value =>
          PhoneNumberId.unwrap(value): java.lang.String
        )
      )(_.phoneNumberId)
      .optionallyWith(
        phoneNumberArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.phoneNumberArn)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdatePhoneNumberResponse.ReadOnly =
    zio.aws.connect.model.UpdatePhoneNumberResponse.wrap(buildAwsValue())
}
object UpdatePhoneNumberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdatePhoneNumberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdatePhoneNumberResponse =
      zio.aws.connect.model.UpdatePhoneNumberResponse(
        phoneNumberId.map(value => value),
        phoneNumberArn.map(value => value)
      )
    def phoneNumberId: Optional[PhoneNumberId]
    def phoneNumberArn: Optional[ARN]
    def getPhoneNumberId: ZIO[Any, AwsError, PhoneNumberId] =
      AwsError.unwrapOptionField("phoneNumberId", phoneNumberId)
    def getPhoneNumberArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("phoneNumberArn", phoneNumberArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdatePhoneNumberResponse
  ) extends zio.aws.connect.model.UpdatePhoneNumberResponse.ReadOnly {
    override val phoneNumberId: Optional[PhoneNumberId] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberId())
      .map(value => zio.aws.connect.model.primitives.PhoneNumberId(value))
    override val phoneNumberArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdatePhoneNumberResponse
  ): zio.aws.connect.model.UpdatePhoneNumberResponse.ReadOnly = new Wrapper(
    impl
  )
}
