package zio.aws.connect.model
import zio.aws.connect.model.primitives.{QueueMaxContacts, QueueId, InstanceId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateQueueMaxContactsRequest(
    instanceId: InstanceId,
    queueId: QueueId,
    maxContacts: Optional[QueueMaxContacts] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateQueueMaxContactsRequest = {
    import UpdateQueueMaxContactsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateQueueMaxContactsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .optionallyWith(
        maxContacts.map(value => QueueMaxContacts.unwrap(value): Integer)
      )(_.maxContacts)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateQueueMaxContactsRequest.ReadOnly =
    zio.aws.connect.model.UpdateQueueMaxContactsRequest.wrap(buildAwsValue())
}
object UpdateQueueMaxContactsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateQueueMaxContactsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateQueueMaxContactsRequest =
      zio.aws.connect.model.UpdateQueueMaxContactsRequest(
        instanceId,
        queueId,
        maxContacts.map(value => value)
      )
    def instanceId: InstanceId
    def queueId: QueueId
    def maxContacts: Optional[QueueMaxContacts]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getMaxContacts: ZIO[Any, AwsError, QueueMaxContacts] =
      AwsError.unwrapOptionField("maxContacts", maxContacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateQueueMaxContactsRequest
  ) extends zio.aws.connect.model.UpdateQueueMaxContactsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val queueId: QueueId =
      zio.aws.connect.model.primitives.QueueId(impl.queueId())
    override val maxContacts: Optional[QueueMaxContacts] = zio.aws.core.internal
      .optionalFromNullable(impl.maxContacts())
      .map(value => zio.aws.connect.model.primitives.QueueMaxContacts(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateQueueMaxContactsRequest
  ): zio.aws.connect.model.UpdateQueueMaxContactsRequest.ReadOnly = new Wrapper(
    impl
  )
}
