package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  QueueDescription,
  CommonNameLength127,
  QueueId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class UpdateQueueNameRequest(
    instanceId: InstanceId,
    queueId: QueueId,
    name: Optional[CommonNameLength127] = Optional.Absent,
    description: Optional[QueueDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateQueueNameRequest = {
    import UpdateQueueNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateQueueNameRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .optionallyWith(
        name.map(value => CommonNameLength127.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          QueueDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateQueueNameRequest.ReadOnly =
    zio.aws.connect.model.UpdateQueueNameRequest.wrap(buildAwsValue())
}
object UpdateQueueNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateQueueNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateQueueNameRequest =
      zio.aws.connect.model.UpdateQueueNameRequest(
        instanceId,
        queueId,
        name.map(value => value),
        description.map(value => value)
      )
    def instanceId: InstanceId
    def queueId: QueueId
    def name: Optional[CommonNameLength127]
    def description: Optional[QueueDescription]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getName: ZIO[Any, AwsError, CommonNameLength127] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, QueueDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateQueueNameRequest
  ) extends zio.aws.connect.model.UpdateQueueNameRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val queueId: QueueId =
      zio.aws.connect.model.primitives.QueueId(impl.queueId())
    override val name: Optional[CommonNameLength127] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.CommonNameLength127(value))
    override val description: Optional[QueueDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.connect.model.primitives.QueueDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateQueueNameRequest
  ): zio.aws.connect.model.UpdateQueueNameRequest.ReadOnly = new Wrapper(impl)
}
