package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  UpdateQuickConnectDescription,
  QuickConnectName,
  QuickConnectId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class UpdateQuickConnectNameRequest(
    instanceId: InstanceId,
    quickConnectId: QuickConnectId,
    name: Optional[QuickConnectName] = Optional.Absent,
    description: Optional[UpdateQuickConnectDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateQuickConnectNameRequest = {
    import UpdateQuickConnectNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateQuickConnectNameRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .quickConnectId(QuickConnectId.unwrap(quickConnectId): java.lang.String)
      .optionallyWith(
        name.map(value => QuickConnectName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          UpdateQuickConnectDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateQuickConnectNameRequest.ReadOnly =
    zio.aws.connect.model.UpdateQuickConnectNameRequest.wrap(buildAwsValue())
}
object UpdateQuickConnectNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateQuickConnectNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateQuickConnectNameRequest =
      zio.aws.connect.model.UpdateQuickConnectNameRequest(
        instanceId,
        quickConnectId,
        name.map(value => value),
        description.map(value => value)
      )
    def instanceId: InstanceId
    def quickConnectId: QuickConnectId
    def name: Optional[QuickConnectName]
    def description: Optional[UpdateQuickConnectDescription]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getQuickConnectId: ZIO[Any, Nothing, QuickConnectId] =
      ZIO.succeed(quickConnectId)
    def getName: ZIO[Any, AwsError, QuickConnectName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, UpdateQuickConnectDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateQuickConnectNameRequest
  ) extends zio.aws.connect.model.UpdateQuickConnectNameRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val quickConnectId: QuickConnectId =
      zio.aws.connect.model.primitives.QuickConnectId(impl.quickConnectId())
    override val name: Optional[QuickConnectName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.QuickConnectName(value))
    override val description: Optional[UpdateQuickConnectDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.UpdateQuickConnectDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateQuickConnectNameRequest
  ): zio.aws.connect.model.UpdateQuickConnectNameRequest.ReadOnly = new Wrapper(
    impl
  )
}
