package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  RoutingProfileDescription,
  RoutingProfileName,
  RoutingProfileId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class UpdateRoutingProfileNameRequest(
    instanceId: InstanceId,
    routingProfileId: RoutingProfileId,
    name: Optional[RoutingProfileName] = Optional.Absent,
    description: Optional[RoutingProfileDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateRoutingProfileNameRequest = {
    import UpdateRoutingProfileNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateRoutingProfileNameRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .routingProfileId(
        RoutingProfileId.unwrap(routingProfileId): java.lang.String
      )
      .optionallyWith(
        name.map(value => RoutingProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          RoutingProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateRoutingProfileNameRequest.ReadOnly =
    zio.aws.connect.model.UpdateRoutingProfileNameRequest.wrap(buildAwsValue())
}
object UpdateRoutingProfileNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateRoutingProfileNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateRoutingProfileNameRequest =
      zio.aws.connect.model.UpdateRoutingProfileNameRequest(
        instanceId,
        routingProfileId,
        name.map(value => value),
        description.map(value => value)
      )
    def instanceId: InstanceId
    def routingProfileId: RoutingProfileId
    def name: Optional[RoutingProfileName]
    def description: Optional[RoutingProfileDescription]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getRoutingProfileId: ZIO[Any, Nothing, RoutingProfileId] =
      ZIO.succeed(routingProfileId)
    def getName: ZIO[Any, AwsError, RoutingProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, RoutingProfileDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateRoutingProfileNameRequest
  ) extends zio.aws.connect.model.UpdateRoutingProfileNameRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val routingProfileId: RoutingProfileId =
      zio.aws.connect.model.primitives.RoutingProfileId(impl.routingProfileId())
    override val name: Optional[RoutingProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.RoutingProfileName(value))
    override val description: Optional[RoutingProfileDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.RoutingProfileDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateRoutingProfileNameRequest
  ): zio.aws.connect.model.UpdateRoutingProfileNameRequest.ReadOnly =
    new Wrapper(impl)
}
