package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  TaskTemplateArn,
  TaskTemplateDescription,
  InstanceId,
  Timestamp,
  TaskTemplateId,
  TaskTemplateName,
  ContactFlowId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UpdateTaskTemplateResponse(
    instanceId: Optional[InstanceId] = Optional.Absent,
    id: Optional[TaskTemplateId] = Optional.Absent,
    arn: Optional[TaskTemplateArn] = Optional.Absent,
    name: Optional[TaskTemplateName] = Optional.Absent,
    description: Optional[TaskTemplateDescription] = Optional.Absent,
    contactFlowId: Optional[ContactFlowId] = Optional.Absent,
    constraints: Optional[zio.aws.connect.model.TaskTemplateConstraints] =
      Optional.Absent,
    defaults: Optional[zio.aws.connect.model.TaskTemplateDefaults] =
      Optional.Absent,
    fields: Optional[Iterable[zio.aws.connect.model.TaskTemplateField]] =
      Optional.Absent,
    status: Optional[zio.aws.connect.model.TaskTemplateStatus] =
      Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateTaskTemplateResponse = {
    import UpdateTaskTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateTaskTemplateResponse
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        id.map(value => TaskTemplateId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => TaskTemplateArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => TaskTemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          TaskTemplateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        contactFlowId.map(value =>
          ContactFlowId.unwrap(value): java.lang.String
        )
      )(_.contactFlowId)
      .optionallyWith(constraints.map(value => value.buildAwsValue()))(
        _.constraints
      )
      .optionallyWith(defaults.map(value => value.buildAwsValue()))(_.defaults)
      .optionallyWith(
        fields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fields)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateTaskTemplateResponse.ReadOnly =
    zio.aws.connect.model.UpdateTaskTemplateResponse.wrap(buildAwsValue())
}
object UpdateTaskTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateTaskTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateTaskTemplateResponse =
      zio.aws.connect.model.UpdateTaskTemplateResponse(
        instanceId.map(value => value),
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        contactFlowId.map(value => value),
        constraints.map(value => value.asEditable),
        defaults.map(value => value.asEditable),
        fields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        lastModifiedTime.map(value => value),
        createdTime.map(value => value)
      )
    def instanceId: Optional[InstanceId]
    def id: Optional[TaskTemplateId]
    def arn: Optional[TaskTemplateArn]
    def name: Optional[TaskTemplateName]
    def description: Optional[TaskTemplateDescription]
    def contactFlowId: Optional[ContactFlowId]
    def constraints
        : Optional[zio.aws.connect.model.TaskTemplateConstraints.ReadOnly]
    def defaults: Optional[zio.aws.connect.model.TaskTemplateDefaults.ReadOnly]
    def fields: Optional[List[zio.aws.connect.model.TaskTemplateField.ReadOnly]]
    def status: Optional[zio.aws.connect.model.TaskTemplateStatus]
    def lastModifiedTime: Optional[Timestamp]
    def createdTime: Optional[Timestamp]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getId: ZIO[Any, AwsError, TaskTemplateId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, TaskTemplateArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, TaskTemplateName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, TaskTemplateDescription] =
      AwsError.unwrapOptionField("description", description)
    def getContactFlowId: ZIO[Any, AwsError, ContactFlowId] =
      AwsError.unwrapOptionField("contactFlowId", contactFlowId)
    def getConstraints: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TaskTemplateConstraints.ReadOnly
    ] = AwsError.unwrapOptionField("constraints", constraints)
    def getDefaults: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.TaskTemplateDefaults.ReadOnly
    ] = AwsError.unwrapOptionField("defaults", defaults)
    def getFields: ZIO[Any, AwsError, List[
      zio.aws.connect.model.TaskTemplateField.ReadOnly
    ]] = AwsError.unwrapOptionField("fields", fields)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.connect.model.TaskTemplateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateTaskTemplateResponse
  ) extends zio.aws.connect.model.UpdateTaskTemplateResponse.ReadOnly {
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.connect.model.primitives.InstanceId(value))
    override val id: Optional[TaskTemplateId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.TaskTemplateId(value))
    override val arn: Optional[TaskTemplateArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.TaskTemplateArn(value))
    override val name: Optional[TaskTemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.TaskTemplateName(value))
    override val description: Optional[TaskTemplateDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.TaskTemplateDescription(value)
        )
    override val contactFlowId: Optional[ContactFlowId] = zio.aws.core.internal
      .optionalFromNullable(impl.contactFlowId())
      .map(value => zio.aws.connect.model.primitives.ContactFlowId(value))
    override val constraints
        : Optional[zio.aws.connect.model.TaskTemplateConstraints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constraints())
        .map(value => zio.aws.connect.model.TaskTemplateConstraints.wrap(value))
    override val defaults
        : Optional[zio.aws.connect.model.TaskTemplateDefaults.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaults())
        .map(value => zio.aws.connect.model.TaskTemplateDefaults.wrap(value))
    override val fields
        : Optional[List[zio.aws.connect.model.TaskTemplateField.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.TaskTemplateField.wrap(item)
          }.toList
        )
    override val status: Optional[zio.aws.connect.model.TaskTemplateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.connect.model.TaskTemplateStatus.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.connect.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateTaskTemplateResponse
  ): zio.aws.connect.model.UpdateTaskTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
