package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{InstanceId, UserId, HierarchyGroupId}
import scala.jdk.CollectionConverters._
final case class UpdateUserHierarchyRequest(
    hierarchyGroupId: Optional[HierarchyGroupId] = Optional.Absent,
    userId: UserId,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateUserHierarchyRequest = {
    import UpdateUserHierarchyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateUserHierarchyRequest
      .builder()
      .optionallyWith(
        hierarchyGroupId.map(value =>
          HierarchyGroupId.unwrap(value): java.lang.String
        )
      )(_.hierarchyGroupId)
      .userId(UserId.unwrap(userId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UpdateUserHierarchyRequest.ReadOnly =
    zio.aws.connect.model.UpdateUserHierarchyRequest.wrap(buildAwsValue())
}
object UpdateUserHierarchyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateUserHierarchyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateUserHierarchyRequest =
      zio.aws.connect.model.UpdateUserHierarchyRequest(
        hierarchyGroupId.map(value => value),
        userId,
        instanceId
      )
    def hierarchyGroupId: Optional[HierarchyGroupId]
    def userId: UserId
    def instanceId: InstanceId
    def getHierarchyGroupId: ZIO[Any, AwsError, HierarchyGroupId] =
      AwsError.unwrapOptionField("hierarchyGroupId", hierarchyGroupId)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateUserHierarchyRequest
  ) extends zio.aws.connect.model.UpdateUserHierarchyRequest.ReadOnly {
    override val hierarchyGroupId: Optional[HierarchyGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hierarchyGroupId())
        .map(value => zio.aws.connect.model.primitives.HierarchyGroupId(value))
    override val userId: UserId =
      zio.aws.connect.model.primitives.UserId(impl.userId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateUserHierarchyRequest
  ): zio.aws.connect.model.UpdateUserHierarchyRequest.ReadOnly = new Wrapper(
    impl
  )
}
