package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{InstanceId, UserId, SecurityProfileId}
import scala.jdk.CollectionConverters._
final case class UpdateUserSecurityProfilesRequest(
    securityProfileIds: Iterable[SecurityProfileId],
    userId: UserId,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesRequest = {
    import UpdateUserSecurityProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesRequest
      .builder()
      .securityProfileIds(securityProfileIds.map { item =>
        SecurityProfileId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .userId(UserId.unwrap(userId): java.lang.String)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.UpdateUserSecurityProfilesRequest.ReadOnly =
    zio.aws.connect.model.UpdateUserSecurityProfilesRequest
      .wrap(buildAwsValue())
}
object UpdateUserSecurityProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UpdateUserSecurityProfilesRequest =
      zio.aws.connect.model.UpdateUserSecurityProfilesRequest(
        securityProfileIds,
        userId,
        instanceId
      )
    def securityProfileIds: List[SecurityProfileId]
    def userId: UserId
    def instanceId: InstanceId
    def getSecurityProfileIds: ZIO[Any, Nothing, List[SecurityProfileId]] =
      ZIO.succeed(securityProfileIds)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesRequest
  ) extends zio.aws.connect.model.UpdateUserSecurityProfilesRequest.ReadOnly {
    override val securityProfileIds: List[SecurityProfileId] = impl
      .securityProfileIds()
      .asScala
      .map { item =>
        zio.aws.connect.model.primitives.SecurityProfileId(item)
      }
      .toList
    override val userId: UserId =
      zio.aws.connect.model.primitives.UserId(impl.userId())
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesRequest
  ): zio.aws.connect.model.UpdateUserSecurityProfilesRequest.ReadOnly =
    new Wrapper(impl)
}
