package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ARN, UseCaseId}
import scala.jdk.CollectionConverters._
final case class UseCase(
    useCaseId: Optional[UseCaseId] = Optional.Absent,
    useCaseArn: Optional[ARN] = Optional.Absent,
    useCaseType: Optional[zio.aws.connect.model.UseCaseType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.connect.model.UseCase = {
    import UseCase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UseCase
      .builder()
      .optionallyWith(
        useCaseId.map(value => UseCaseId.unwrap(value): java.lang.String)
      )(_.useCaseId)
      .optionallyWith(
        useCaseArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.useCaseArn)
      .optionallyWith(useCaseType.map(value => value.unwrap))(_.useCaseType)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UseCase.ReadOnly =
    zio.aws.connect.model.UseCase.wrap(buildAwsValue())
}
object UseCase {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.UseCase] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UseCase =
      zio.aws.connect.model.UseCase(
        useCaseId.map(value => value),
        useCaseArn.map(value => value),
        useCaseType.map(value => value)
      )
    def useCaseId: Optional[UseCaseId]
    def useCaseArn: Optional[ARN]
    def useCaseType: Optional[zio.aws.connect.model.UseCaseType]
    def getUseCaseId: ZIO[Any, AwsError, UseCaseId] =
      AwsError.unwrapOptionField("useCaseId", useCaseId)
    def getUseCaseArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("useCaseArn", useCaseArn)
    def getUseCaseType: ZIO[Any, AwsError, zio.aws.connect.model.UseCaseType] =
      AwsError.unwrapOptionField("useCaseType", useCaseType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UseCase
  ) extends zio.aws.connect.model.UseCase.ReadOnly {
    override val useCaseId: Optional[UseCaseId] = zio.aws.core.internal
      .optionalFromNullable(impl.useCaseId())
      .map(value => zio.aws.connect.model.primitives.UseCaseId(value))
    override val useCaseArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.useCaseArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val useCaseType: Optional[zio.aws.connect.model.UseCaseType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useCaseType())
        .map(value => zio.aws.connect.model.UseCaseType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UseCase
  ): zio.aws.connect.model.UseCase.ReadOnly = new Wrapper(impl)
}
