package zio.aws.connect.model
import zio.aws.connect.model.primitives.IntegerCount
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UserData(
    user: Optional[zio.aws.connect.model.UserReference] = Optional.Absent,
    routingProfile: Optional[zio.aws.connect.model.RoutingProfileReference] =
      Optional.Absent,
    hierarchyPath: Optional[zio.aws.connect.model.HierarchyPathReference] =
      Optional.Absent,
    status: Optional[zio.aws.connect.model.AgentStatusReference] =
      Optional.Absent,
    availableSlotsByChannel: Optional[
      Map[zio.aws.connect.model.Channel, IntegerCount]
    ] = Optional.Absent,
    maxSlotsByChannel: Optional[
      Map[zio.aws.connect.model.Channel, IntegerCount]
    ] = Optional.Absent,
    activeSlotsByChannel: Optional[
      Map[zio.aws.connect.model.Channel, IntegerCount]
    ] = Optional.Absent,
    contacts: Optional[Iterable[zio.aws.connect.model.AgentContactReference]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UserData = {
    import UserData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UserData
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .optionallyWith(routingProfile.map(value => value.buildAwsValue()))(
        _.routingProfile
      )
      .optionallyWith(hierarchyPath.map(value => value.buildAwsValue()))(
        _.hierarchyPath
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        availableSlotsByChannel.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (IntegerCount.unwrap(value): Integer)
            })
            .asJava
        )
      )(_.availableSlotsByChannelWithStrings)
      .optionallyWith(
        maxSlotsByChannel.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (IntegerCount.unwrap(value): Integer)
            })
            .asJava
        )
      )(_.maxSlotsByChannelWithStrings)
      .optionallyWith(
        activeSlotsByChannel.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (IntegerCount.unwrap(value): Integer)
            })
            .asJava
        )
      )(_.activeSlotsByChannelWithStrings)
      .optionallyWith(
        contacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contacts)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UserData.ReadOnly =
    zio.aws.connect.model.UserData.wrap(buildAwsValue())
}
object UserData {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connect.model.UserData] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UserData =
      zio.aws.connect.model.UserData(
        user.map(value => value.asEditable),
        routingProfile.map(value => value.asEditable),
        hierarchyPath.map(value => value.asEditable),
        status.map(value => value.asEditable),
        availableSlotsByChannel.map(value => value),
        maxSlotsByChannel.map(value => value),
        activeSlotsByChannel.map(value => value),
        contacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def user: Optional[zio.aws.connect.model.UserReference.ReadOnly]
    def routingProfile
        : Optional[zio.aws.connect.model.RoutingProfileReference.ReadOnly]
    def hierarchyPath
        : Optional[zio.aws.connect.model.HierarchyPathReference.ReadOnly]
    def status: Optional[zio.aws.connect.model.AgentStatusReference.ReadOnly]
    def availableSlotsByChannel
        : Optional[Map[zio.aws.connect.model.Channel, IntegerCount]]
    def maxSlotsByChannel
        : Optional[Map[zio.aws.connect.model.Channel, IntegerCount]]
    def activeSlotsByChannel
        : Optional[Map[zio.aws.connect.model.Channel, IntegerCount]]
    def contacts
        : Optional[List[zio.aws.connect.model.AgentContactReference.ReadOnly]]
    def getUser
        : ZIO[Any, AwsError, zio.aws.connect.model.UserReference.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
    def getRoutingProfile: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.RoutingProfileReference.ReadOnly
    ] = AwsError.unwrapOptionField("routingProfile", routingProfile)
    def getHierarchyPath: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HierarchyPathReference.ReadOnly
    ] = AwsError.unwrapOptionField("hierarchyPath", hierarchyPath)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.AgentStatusReference.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getAvailableSlotsByChannel
        : ZIO[Any, AwsError, Map[zio.aws.connect.model.Channel, IntegerCount]] =
      AwsError.unwrapOptionField(
        "availableSlotsByChannel",
        availableSlotsByChannel
      )
    def getMaxSlotsByChannel
        : ZIO[Any, AwsError, Map[zio.aws.connect.model.Channel, IntegerCount]] =
      AwsError.unwrapOptionField("maxSlotsByChannel", maxSlotsByChannel)
    def getActiveSlotsByChannel
        : ZIO[Any, AwsError, Map[zio.aws.connect.model.Channel, IntegerCount]] =
      AwsError.unwrapOptionField("activeSlotsByChannel", activeSlotsByChannel)
    def getContacts: ZIO[Any, AwsError, List[
      zio.aws.connect.model.AgentContactReference.ReadOnly
    ]] = AwsError.unwrapOptionField("contacts", contacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UserData
  ) extends zio.aws.connect.model.UserData.ReadOnly {
    override val user: Optional[zio.aws.connect.model.UserReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.user())
        .map(value => zio.aws.connect.model.UserReference.wrap(value))
    override val routingProfile
        : Optional[zio.aws.connect.model.RoutingProfileReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingProfile())
        .map(value => zio.aws.connect.model.RoutingProfileReference.wrap(value))
    override val hierarchyPath
        : Optional[zio.aws.connect.model.HierarchyPathReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hierarchyPath())
        .map(value => zio.aws.connect.model.HierarchyPathReference.wrap(value))
    override val status
        : Optional[zio.aws.connect.model.AgentStatusReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.connect.model.AgentStatusReference.wrap(value))
    override val availableSlotsByChannel
        : Optional[Map[zio.aws.connect.model.Channel, IntegerCount]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableSlotsByChannel())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.connect.model.Channel.wrap(
                key
              ) -> zio.aws.connect.model.primitives.IntegerCount(value)
            })
            .toMap
        )
    override val maxSlotsByChannel
        : Optional[Map[zio.aws.connect.model.Channel, IntegerCount]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxSlotsByChannel())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.connect.model.Channel.wrap(
                key
              ) -> zio.aws.connect.model.primitives.IntegerCount(value)
            })
            .toMap
        )
    override val activeSlotsByChannel
        : Optional[Map[zio.aws.connect.model.Channel, IntegerCount]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeSlotsByChannel())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.connect.model.Channel.wrap(
                key
              ) -> zio.aws.connect.model.primitives.IntegerCount(value)
            })
            .toMap
        )
    override val contacts
        : Optional[List[zio.aws.connect.model.AgentContactReference.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.AgentContactReference.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UserData
  ): zio.aws.connect.model.UserData.ReadOnly = new Wrapper(impl)
}
