package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.QueueId
import scala.jdk.CollectionConverters._
final case class UserDataFilters(
    queues: Optional[Iterable[QueueId]] = Optional.Absent,
    contactFilter: Optional[zio.aws.connect.model.ContactFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UserDataFilters = {
    import UserDataFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UserDataFilters
      .builder()
      .optionallyWith(
        queues.map(value =>
          value.map { item =>
            QueueId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.queues)
      .optionallyWith(contactFilter.map(value => value.buildAwsValue()))(
        _.contactFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UserDataFilters.ReadOnly =
    zio.aws.connect.model.UserDataFilters.wrap(buildAwsValue())
}
object UserDataFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UserDataFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UserDataFilters =
      zio.aws.connect.model.UserDataFilters(
        queues.map(value => value),
        contactFilter.map(value => value.asEditable)
      )
    def queues: Optional[List[QueueId]]
    def contactFilter: Optional[zio.aws.connect.model.ContactFilter.ReadOnly]
    def getQueues: ZIO[Any, AwsError, List[QueueId]] =
      AwsError.unwrapOptionField("queues", queues)
    def getContactFilter
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactFilter.ReadOnly] =
      AwsError.unwrapOptionField("contactFilter", contactFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UserDataFilters
  ) extends zio.aws.connect.model.UserDataFilters.ReadOnly {
    override val queues: Optional[List[QueueId]] = zio.aws.core.internal
      .optionalFromNullable(impl.queues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.QueueId(item)
        }.toList
      )
    override val contactFilter
        : Optional[zio.aws.connect.model.ContactFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactFilter())
        .map(value => zio.aws.connect.model.ContactFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UserDataFilters
  ): zio.aws.connect.model.UserDataFilters.ReadOnly = new Wrapper(impl)
}
