package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{AgentLastName, AgentFirstName}
import scala.jdk.CollectionConverters._
final case class UserIdentityInfoLite(
    firstName: Optional[AgentFirstName] = Optional.Absent,
    lastName: Optional[AgentLastName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UserIdentityInfoLite = {
    import UserIdentityInfoLite.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UserIdentityInfoLite
      .builder()
      .optionallyWith(
        firstName.map(value => AgentFirstName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => AgentLastName.unwrap(value): java.lang.String)
      )(_.lastName)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UserIdentityInfoLite.ReadOnly =
    zio.aws.connect.model.UserIdentityInfoLite.wrap(buildAwsValue())
}
object UserIdentityInfoLite {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UserIdentityInfoLite
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UserIdentityInfoLite =
      zio.aws.connect.model.UserIdentityInfoLite(
        firstName.map(value => value),
        lastName.map(value => value)
      )
    def firstName: Optional[AgentFirstName]
    def lastName: Optional[AgentLastName]
    def getFirstName: ZIO[Any, AwsError, AgentFirstName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, AgentLastName] =
      AwsError.unwrapOptionField("lastName", lastName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UserIdentityInfoLite
  ) extends zio.aws.connect.model.UserIdentityInfoLite.ReadOnly {
    override val firstName: Optional[AgentFirstName] = zio.aws.core.internal
      .optionalFromNullable(impl.firstName())
      .map(value => zio.aws.connect.model.primitives.AgentFirstName(value))
    override val lastName: Optional[AgentLastName] = zio.aws.core.internal
      .optionalFromNullable(impl.lastName())
      .map(value => zio.aws.connect.model.primitives.AgentLastName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UserIdentityInfoLite
  ): zio.aws.connect.model.UserIdentityInfoLite.ReadOnly = new Wrapper(impl)
}
