package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ARN, UserId}
import scala.jdk.CollectionConverters._
final case class UserReference(
    id: Optional[UserId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UserReference = {
    import UserReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UserReference
      .builder()
      .optionallyWith(id.map(value => UserId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UserReference.ReadOnly =
    zio.aws.connect.model.UserReference.wrap(buildAwsValue())
}
object UserReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UserReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UserReference = zio.aws.connect.model
      .UserReference(id.map(value => value), arn.map(value => value))
    def id: Optional[UserId]
    def arn: Optional[ARN]
    def getId: ZIO[Any, AwsError, UserId] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UserReference
  ) extends zio.aws.connect.model.UserReference.ReadOnly {
    override val id: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.UserId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UserReference
  ): zio.aws.connect.model.UserReference.ReadOnly = new Wrapper(impl)
}
