package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserSearchCriteria(
    orConditions: Optional[Iterable[zio.aws.connect.model.UserSearchCriteria]] =
      Optional.Absent,
    andConditions: Optional[
      Iterable[zio.aws.connect.model.UserSearchCriteria]
    ] = Optional.Absent,
    stringCondition: Optional[zio.aws.connect.model.StringCondition] =
      Optional.Absent,
    hierarchyGroupCondition: Optional[
      zio.aws.connect.model.HierarchyGroupCondition
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.UserSearchCriteria = {
    import UserSearchCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.UserSearchCriteria
      .builder()
      .optionallyWith(
        orConditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orConditions)
      .optionallyWith(
        andConditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.andConditions)
      .optionallyWith(stringCondition.map(value => value.buildAwsValue()))(
        _.stringCondition
      )
      .optionallyWith(
        hierarchyGroupCondition.map(value => value.buildAwsValue())
      )(_.hierarchyGroupCondition)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.UserSearchCriteria.ReadOnly =
    zio.aws.connect.model.UserSearchCriteria.wrap(buildAwsValue())
}
object UserSearchCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.UserSearchCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.UserSearchCriteria =
      zio.aws.connect.model.UserSearchCriteria(
        orConditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        andConditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stringCondition.map(value => value.asEditable),
        hierarchyGroupCondition.map(value => value.asEditable)
      )
    def orConditions
        : Optional[List[zio.aws.connect.model.UserSearchCriteria.ReadOnly]]
    def andConditions
        : Optional[List[zio.aws.connect.model.UserSearchCriteria.ReadOnly]]
    def stringCondition
        : Optional[zio.aws.connect.model.StringCondition.ReadOnly]
    def hierarchyGroupCondition
        : Optional[zio.aws.connect.model.HierarchyGroupCondition.ReadOnly]
    def getOrConditions: ZIO[Any, AwsError, List[
      zio.aws.connect.model.UserSearchCriteria.ReadOnly
    ]] = AwsError.unwrapOptionField("orConditions", orConditions)
    def getAndConditions: ZIO[Any, AwsError, List[
      zio.aws.connect.model.UserSearchCriteria.ReadOnly
    ]] = AwsError.unwrapOptionField("andConditions", andConditions)
    def getStringCondition
        : ZIO[Any, AwsError, zio.aws.connect.model.StringCondition.ReadOnly] =
      AwsError.unwrapOptionField("stringCondition", stringCondition)
    def getHierarchyGroupCondition: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.HierarchyGroupCondition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "hierarchyGroupCondition",
      hierarchyGroupCondition
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.UserSearchCriteria
  ) extends zio.aws.connect.model.UserSearchCriteria.ReadOnly {
    override val orConditions
        : Optional[List[zio.aws.connect.model.UserSearchCriteria.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orConditions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.UserSearchCriteria.wrap(item)
          }.toList
        )
    override val andConditions
        : Optional[List[zio.aws.connect.model.UserSearchCriteria.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.andConditions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.UserSearchCriteria.wrap(item)
          }.toList
        )
    override val stringCondition
        : Optional[zio.aws.connect.model.StringCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stringCondition())
        .map(value => zio.aws.connect.model.StringCondition.wrap(value))
    override val hierarchyGroupCondition
        : Optional[zio.aws.connect.model.HierarchyGroupCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hierarchyGroupCondition())
        .map(value => zio.aws.connect.model.HierarchyGroupCondition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.UserSearchCriteria
  ): zio.aws.connect.model.UserSearchCriteria.ReadOnly = new Wrapper(impl)
}
