package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  VocabularyId,
  VocabularyContent,
  TagValue,
  VocabularyLastModifiedTime,
  VocabularyName,
  VocabularyFailureReason,
  ARN,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Vocabulary(
    name: VocabularyName,
    id: VocabularyId,
    arn: ARN,
    languageCode: zio.aws.connect.model.VocabularyLanguageCode,
    state: zio.aws.connect.model.VocabularyState,
    lastModifiedTime: VocabularyLastModifiedTime,
    failureReason: Optional[VocabularyFailureReason] = Optional.Absent,
    content: Optional[VocabularyContent] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.Vocabulary = {
    import Vocabulary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.Vocabulary
      .builder()
      .name(VocabularyName.unwrap(name): java.lang.String)
      .id(VocabularyId.unwrap(id): java.lang.String)
      .arn(ARN.unwrap(arn): java.lang.String)
      .languageCode(languageCode.unwrap)
      .state(state.unwrap)
      .lastModifiedTime(
        VocabularyLastModifiedTime.unwrap(lastModifiedTime): Instant
      )
      .optionallyWith(
        failureReason.map(value =>
          VocabularyFailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        content.map(value => VocabularyContent.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.Vocabulary.ReadOnly =
    zio.aws.connect.model.Vocabulary.wrap(buildAwsValue())
}
object Vocabulary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.Vocabulary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.Vocabulary =
      zio.aws.connect.model.Vocabulary(
        name,
        id,
        arn,
        languageCode,
        state,
        lastModifiedTime,
        failureReason.map(value => value),
        content.map(value => value),
        tags.map(value => value)
      )
    def name: VocabularyName
    def id: VocabularyId
    def arn: ARN
    def languageCode: zio.aws.connect.model.VocabularyLanguageCode
    def state: zio.aws.connect.model.VocabularyState
    def lastModifiedTime: VocabularyLastModifiedTime
    def failureReason: Optional[VocabularyFailureReason]
    def content: Optional[VocabularyContent]
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, VocabularyName] = ZIO.succeed(name)
    def getId: ZIO[Any, Nothing, VocabularyId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(arn)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.connect.model.VocabularyLanguageCode] =
      ZIO.succeed(languageCode)
    def getState: ZIO[Any, Nothing, zio.aws.connect.model.VocabularyState] =
      ZIO.succeed(state)
    def getLastModifiedTime: ZIO[Any, Nothing, VocabularyLastModifiedTime] =
      ZIO.succeed(lastModifiedTime)
    def getFailureReason: ZIO[Any, AwsError, VocabularyFailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getContent: ZIO[Any, AwsError, VocabularyContent] =
      AwsError.unwrapOptionField("content", content)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.Vocabulary
  ) extends zio.aws.connect.model.Vocabulary.ReadOnly {
    override val name: VocabularyName =
      zio.aws.connect.model.primitives.VocabularyName(impl.name())
    override val id: VocabularyId =
      zio.aws.connect.model.primitives.VocabularyId(impl.id())
    override val arn: ARN = zio.aws.connect.model.primitives.ARN(impl.arn())
    override val languageCode: zio.aws.connect.model.VocabularyLanguageCode =
      zio.aws.connect.model.VocabularyLanguageCode.wrap(impl.languageCode())
    override val state: zio.aws.connect.model.VocabularyState =
      zio.aws.connect.model.VocabularyState.wrap(impl.state())
    override val lastModifiedTime: VocabularyLastModifiedTime =
      zio.aws.connect.model.primitives
        .VocabularyLastModifiedTime(impl.lastModifiedTime())
    override val failureReason: Optional[VocabularyFailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value =>
          zio.aws.connect.model.primitives.VocabularyFailureReason(value)
        )
    override val content: Optional[VocabularyContent] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.connect.model.primitives.VocabularyContent(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.Vocabulary
  ): zio.aws.connect.model.Vocabulary.ReadOnly = new Wrapper(impl)
}
