package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait VocabularyState {
  def unwrap: software.amazon.awssdk.services.connect.model.VocabularyState
}
object VocabularyState {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.VocabularyState
  ): zio.aws.connect.model.VocabularyState = value match {
    case software.amazon.awssdk.services.connect.model.VocabularyState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.VocabularyState.CREATION_IN_PROGRESS =>
      val r = CREATION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.connect.model.VocabularyState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.connect.model.VocabularyState.CREATION_FAILED =>
      val r = CREATION_FAILED
      r
    case software.amazon.awssdk.services.connect.model.VocabularyState.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.VocabularyState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.VocabularyState =
      software.amazon.awssdk.services.connect.model.VocabularyState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATION_IN_PROGRESS
      extends zio.aws.connect.model.VocabularyState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.VocabularyState =
      software.amazon.awssdk.services.connect.model.VocabularyState.CREATION_IN_PROGRESS
  }
  case object ACTIVE extends zio.aws.connect.model.VocabularyState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.VocabularyState =
      software.amazon.awssdk.services.connect.model.VocabularyState.ACTIVE
  }
  case object CREATION_FAILED extends zio.aws.connect.model.VocabularyState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.VocabularyState =
      software.amazon.awssdk.services.connect.model.VocabularyState.CREATION_FAILED
  }
  case object DELETE_IN_PROGRESS extends zio.aws.connect.model.VocabularyState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.VocabularyState =
      software.amazon.awssdk.services.connect.model.VocabularyState.DELETE_IN_PROGRESS
  }
}
