package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VoiceRecordingConfiguration(
    voiceRecordingTrack: Optional[zio.aws.connect.model.VoiceRecordingTrack] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.VoiceRecordingConfiguration = {
    import VoiceRecordingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.VoiceRecordingConfiguration
      .builder()
      .optionallyWith(voiceRecordingTrack.map(value => value.unwrap))(
        _.voiceRecordingTrack
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.VoiceRecordingConfiguration.ReadOnly =
    zio.aws.connect.model.VoiceRecordingConfiguration.wrap(buildAwsValue())
}
object VoiceRecordingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.VoiceRecordingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.VoiceRecordingConfiguration =
      zio.aws.connect.model
        .VoiceRecordingConfiguration(voiceRecordingTrack.map(value => value))
    def voiceRecordingTrack: Optional[zio.aws.connect.model.VoiceRecordingTrack]
    def getVoiceRecordingTrack
        : ZIO[Any, AwsError, zio.aws.connect.model.VoiceRecordingTrack] =
      AwsError.unwrapOptionField("voiceRecordingTrack", voiceRecordingTrack)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.VoiceRecordingConfiguration
  ) extends zio.aws.connect.model.VoiceRecordingConfiguration.ReadOnly {
    override val voiceRecordingTrack
        : Optional[zio.aws.connect.model.VoiceRecordingTrack] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceRecordingTrack())
        .map(value => zio.aws.connect.model.VoiceRecordingTrack.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.VoiceRecordingConfiguration
  ): zio.aws.connect.model.VoiceRecordingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
