package zio.aws.connect
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.connect.model.primitives.{
  QuickConnectId,
  QueueId,
  AttributeName,
  SupportedMessagingContentType,
  SecurityProfilePermission,
  TagValue,
  TaskTemplateSingleSelectOption,
  ReferenceKey,
  IntegerCount,
  FunctionArn,
  Origin,
  AttributeValue,
  TagKey,
  SecurityProfileId
}
import zio.aws.connect.model.primitives.MaxResult1000.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ARN extends Subtype[String]
    type ARN = zio.aws.connect.model.primitives.ARN.Type
    object AfterContactWorkTimeLimit extends Subtype[Int]
    type AfterContactWorkTimeLimit =
      zio.aws.connect.model.primitives.AfterContactWorkTimeLimit.Type
    object AgentFirstName extends Subtype[String]
    type AgentFirstName = zio.aws.connect.model.primitives.AgentFirstName.Type
    object AgentLastName extends Subtype[String]
    type AgentLastName = zio.aws.connect.model.primitives.AgentLastName.Type
    object AgentResourceId extends Subtype[String]
    type AgentResourceId = zio.aws.connect.model.primitives.AgentResourceId.Type
    object AgentStatusDescription extends Subtype[String]
    type AgentStatusDescription =
      zio.aws.connect.model.primitives.AgentStatusDescription.Type
    object AgentStatusId extends Subtype[String]
    type AgentStatusId = zio.aws.connect.model.primitives.AgentStatusId.Type
    object AgentStatusName extends Subtype[String]
    type AgentStatusName = zio.aws.connect.model.primitives.AgentStatusName.Type
    object AgentStatusOrderNumber extends Subtype[Int]
    type AgentStatusOrderNumber =
      zio.aws.connect.model.primitives.AgentStatusOrderNumber.Type
    object AgentUsername extends Subtype[String]
    type AgentUsername = zio.aws.connect.model.primitives.AgentUsername.Type
    object AliasArn extends Subtype[String]
    type AliasArn = zio.aws.connect.model.primitives.AliasArn.Type
    object ApproximateTotalCount extends Subtype[Long]
    type ApproximateTotalCount =
      zio.aws.connect.model.primitives.ApproximateTotalCount.Type
    object AssociationId extends Subtype[String]
    type AssociationId = zio.aws.connect.model.primitives.AssociationId.Type
    object AttributeName extends Subtype[String]
    type AttributeName = zio.aws.connect.model.primitives.AttributeName.Type
    object AttributeValue extends Subtype[String]
    type AttributeValue = zio.aws.connect.model.primitives.AttributeValue.Type
    object AutoAccept extends Subtype[Boolean]
    type AutoAccept = zio.aws.connect.model.primitives.AutoAccept.Type
    object AwsRegion extends Subtype[String]
    type AwsRegion = zio.aws.connect.model.primitives.AwsRegion.Type
    object BotName extends Subtype[String]
    type BotName = zio.aws.connect.model.primitives.BotName.Type
    object BucketName extends Subtype[String]
    type BucketName = zio.aws.connect.model.primitives.BucketName.Type
    object CampaignId extends Subtype[String]
    type CampaignId = zio.aws.connect.model.primitives.CampaignId.Type
    object ChatContent extends Subtype[String]
    type ChatContent = zio.aws.connect.model.primitives.ChatContent.Type
    object ChatContentType extends Subtype[String]
    type ChatContentType = zio.aws.connect.model.primitives.ChatContentType.Type
    object ChatDurationInMinutes extends Subtype[Int]
    type ChatDurationInMinutes =
      zio.aws.connect.model.primitives.ChatDurationInMinutes.Type
    object ChatStreamingEndpointARN extends Subtype[String]
    type ChatStreamingEndpointARN =
      zio.aws.connect.model.primitives.ChatStreamingEndpointARN.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.connect.model.primitives.ClientToken.Type
    object CommonNameLength127 extends Subtype[String]
    type CommonNameLength127 =
      zio.aws.connect.model.primitives.CommonNameLength127.Type
    object Concurrency extends Subtype[Int]
    type Concurrency = zio.aws.connect.model.primitives.Concurrency.Type
    object ContactFlowContent extends Subtype[String]
    type ContactFlowContent =
      zio.aws.connect.model.primitives.ContactFlowContent.Type
    object ContactFlowDescription extends Subtype[String]
    type ContactFlowDescription =
      zio.aws.connect.model.primitives.ContactFlowDescription.Type
    object ContactFlowId extends Subtype[String]
    type ContactFlowId = zio.aws.connect.model.primitives.ContactFlowId.Type
    object ContactFlowModuleContent extends Subtype[String]
    type ContactFlowModuleContent =
      zio.aws.connect.model.primitives.ContactFlowModuleContent.Type
    object ContactFlowModuleDescription extends Subtype[String]
    type ContactFlowModuleDescription =
      zio.aws.connect.model.primitives.ContactFlowModuleDescription.Type
    object ContactFlowModuleId extends Subtype[String]
    type ContactFlowModuleId =
      zio.aws.connect.model.primitives.ContactFlowModuleId.Type
    object ContactFlowModuleName extends Subtype[String]
    type ContactFlowModuleName =
      zio.aws.connect.model.primitives.ContactFlowModuleName.Type
    object ContactFlowName extends Subtype[String]
    type ContactFlowName = zio.aws.connect.model.primitives.ContactFlowName.Type
    object ContactId extends Subtype[String]
    type ContactId = zio.aws.connect.model.primitives.ContactId.Type
    object Delay extends Subtype[Int]
    type Delay = zio.aws.connect.model.primitives.Delay.Type
    object Description extends Subtype[String]
    type Description = zio.aws.connect.model.primitives.Description.Type
    object Description250 extends Subtype[String]
    type Description250 = zio.aws.connect.model.primitives.Description250.Type
    object DirectoryAlias extends Subtype[String]
    type DirectoryAlias = zio.aws.connect.model.primitives.DirectoryAlias.Type
    object DirectoryId extends Subtype[String]
    type DirectoryId = zio.aws.connect.model.primitives.DirectoryId.Type
    object DirectoryUserId extends Subtype[String]
    type DirectoryUserId = zio.aws.connect.model.primitives.DirectoryUserId.Type
    object DisplayName extends Subtype[String]
    type DisplayName = zio.aws.connect.model.primitives.DisplayName.Type
    object Email extends Subtype[String]
    type Email = zio.aws.connect.model.primitives.Email.Type
    object FunctionArn extends Subtype[String]
    type FunctionArn = zio.aws.connect.model.primitives.FunctionArn.Type
    object HierarchyGroupId extends Subtype[String]
    type HierarchyGroupId =
      zio.aws.connect.model.primitives.HierarchyGroupId.Type
    object HierarchyGroupName extends Subtype[String]
    type HierarchyGroupName =
      zio.aws.connect.model.primitives.HierarchyGroupName.Type
    object HierarchyLevelId extends Subtype[String]
    type HierarchyLevelId =
      zio.aws.connect.model.primitives.HierarchyLevelId.Type
    object HierarchyLevelName extends Subtype[String]
    type HierarchyLevelName =
      zio.aws.connect.model.primitives.HierarchyLevelName.Type
    object Hours extends Subtype[Int]
    type Hours = zio.aws.connect.model.primitives.Hours.Type
    object Hours24Format extends Subtype[Int]
    type Hours24Format = zio.aws.connect.model.primitives.Hours24Format.Type
    object HoursOfOperationDescription extends Subtype[String]
    type HoursOfOperationDescription =
      zio.aws.connect.model.primitives.HoursOfOperationDescription.Type
    object HoursOfOperationId extends Subtype[String]
    type HoursOfOperationId =
      zio.aws.connect.model.primitives.HoursOfOperationId.Type
    object HoursOfOperationName extends Subtype[String]
    type HoursOfOperationName =
      zio.aws.connect.model.primitives.HoursOfOperationName.Type
    object InboundCallsEnabled extends Subtype[Boolean]
    type InboundCallsEnabled =
      zio.aws.connect.model.primitives.InboundCallsEnabled.Type
    object InstanceArn extends Subtype[String]
    type InstanceArn = zio.aws.connect.model.primitives.InstanceArn.Type
    object InstanceAttributeValue extends Subtype[String]
    type InstanceAttributeValue =
      zio.aws.connect.model.primitives.InstanceAttributeValue.Type
    object InstanceId extends Subtype[String]
    type InstanceId = zio.aws.connect.model.primitives.InstanceId.Type
    object InstanceIdOrArn extends Subtype[String]
    type InstanceIdOrArn = zio.aws.connect.model.primitives.InstanceIdOrArn.Type
    object IntegerCount extends Subtype[Int]
    type IntegerCount = zio.aws.connect.model.primitives.IntegerCount.Type
    object IntegrationAssociationId extends Subtype[String]
    type IntegrationAssociationId =
      zio.aws.connect.model.primitives.IntegrationAssociationId.Type
    object KeyId extends Subtype[String]
    type KeyId = zio.aws.connect.model.primitives.KeyId.Type
    object LargeNextToken extends Subtype[String]
    type LargeNextToken = zio.aws.connect.model.primitives.LargeNextToken.Type
    object LexRegion extends Subtype[String]
    type LexRegion = zio.aws.connect.model.primitives.LexRegion.Type
    object MaxResult10 extends Subtype[Int]
    type MaxResult10 = zio.aws.connect.model.primitives.MaxResult10.Type
    object MaxResult100 extends Subtype[Int]
    type MaxResult100 = zio.aws.connect.model.primitives.MaxResult100.Type
    object MaxResult1000 extends Subtype[Int]
    type MaxResult1000 = zio.aws.connect.model.primitives.MaxResult1000.Type
    object MaxResult2 extends Subtype[Int]
    type MaxResult2 = zio.aws.connect.model.primitives.MaxResult2.Type
    object MaxResult25 extends Subtype[Int]
    type MaxResult25 = zio.aws.connect.model.primitives.MaxResult25.Type
    object MaxResult7 extends Subtype[Int]
    type MaxResult7 = zio.aws.connect.model.primitives.MaxResult7.Type
    object MinutesLimit60 extends Subtype[Int]
    type MinutesLimit60 = zio.aws.connect.model.primitives.MinutesLimit60.Type
    object Name extends Subtype[String]
    type Name = zio.aws.connect.model.primitives.Name.Type
    object Name128 extends Subtype[String]
    type Name128 = zio.aws.connect.model.primitives.Name128.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.connect.model.primitives.NextToken.Type
    object NextToken2500 extends Subtype[String]
    type NextToken2500 = zio.aws.connect.model.primitives.NextToken2500.Type
    object Origin extends Subtype[String]
    type Origin = zio.aws.connect.model.primitives.Origin.Type
    object OutboundCallerIdName extends Subtype[String]
    type OutboundCallerIdName =
      zio.aws.connect.model.primitives.OutboundCallerIdName.Type
    object OutboundCallsEnabled extends Subtype[Boolean]
    type OutboundCallsEnabled =
      zio.aws.connect.model.primitives.OutboundCallsEnabled.Type
    object PEM extends Subtype[String]
    type PEM = zio.aws.connect.model.primitives.PEM.Type
    object ParticipantId extends Subtype[String]
    type ParticipantId = zio.aws.connect.model.primitives.ParticipantId.Type
    object ParticipantToken extends Subtype[String]
    type ParticipantToken =
      zio.aws.connect.model.primitives.ParticipantToken.Type
    object Password extends Subtype[String]
    type Password = zio.aws.connect.model.primitives.Password.Type
    object Percentage extends Subtype[Int]
    type Percentage = zio.aws.connect.model.primitives.Percentage.Type
    object PhoneNumber extends Subtype[String]
    type PhoneNumber = zio.aws.connect.model.primitives.PhoneNumber.Type
    object PhoneNumberDescription extends Subtype[String]
    type PhoneNumberDescription =
      zio.aws.connect.model.primitives.PhoneNumberDescription.Type
    object PhoneNumberId extends Subtype[String]
    type PhoneNumberId = zio.aws.connect.model.primitives.PhoneNumberId.Type
    object PhoneNumberPrefix extends Subtype[String]
    type PhoneNumberPrefix =
      zio.aws.connect.model.primitives.PhoneNumberPrefix.Type
    object PhoneNumberWorkflowMessage extends Subtype[String]
    type PhoneNumberWorkflowMessage =
      zio.aws.connect.model.primitives.PhoneNumberWorkflowMessage.Type
    object Prefix extends Subtype[String]
    type Prefix = zio.aws.connect.model.primitives.Prefix.Type
    object Priority extends Subtype[Int]
    type Priority = zio.aws.connect.model.primitives.Priority.Type
    object PromptId extends Subtype[String]
    type PromptId = zio.aws.connect.model.primitives.PromptId.Type
    object PromptName extends Subtype[String]
    type PromptName = zio.aws.connect.model.primitives.PromptName.Type
    object QueueDescription extends Subtype[String]
    type QueueDescription =
      zio.aws.connect.model.primitives.QueueDescription.Type
    object QueueId extends Subtype[String]
    type QueueId = zio.aws.connect.model.primitives.QueueId.Type
    object QueueMaxContacts extends Subtype[Int]
    type QueueMaxContacts =
      zio.aws.connect.model.primitives.QueueMaxContacts.Type
    object QueueName extends Subtype[String]
    type QueueName = zio.aws.connect.model.primitives.QueueName.Type
    object QuickConnectDescription extends Subtype[String]
    type QuickConnectDescription =
      zio.aws.connect.model.primitives.QuickConnectDescription.Type
    object QuickConnectId extends Subtype[String]
    type QuickConnectId = zio.aws.connect.model.primitives.QuickConnectId.Type
    object QuickConnectName extends Subtype[String]
    type QuickConnectName =
      zio.aws.connect.model.primitives.QuickConnectName.Type
    object ReferenceKey extends Subtype[String]
    type ReferenceKey = zio.aws.connect.model.primitives.ReferenceKey.Type
    object ReferenceValue extends Subtype[String]
    type ReferenceValue = zio.aws.connect.model.primitives.ReferenceValue.Type
    object RoutingProfileDescription extends Subtype[String]
    type RoutingProfileDescription =
      zio.aws.connect.model.primitives.RoutingProfileDescription.Type
    object RoutingProfileId extends Subtype[String]
    type RoutingProfileId =
      zio.aws.connect.model.primitives.RoutingProfileId.Type
    object RoutingProfileName extends Subtype[String]
    type RoutingProfileName =
      zio.aws.connect.model.primitives.RoutingProfileName.Type
    object SecurityProfileDescription extends Subtype[String]
    type SecurityProfileDescription =
      zio.aws.connect.model.primitives.SecurityProfileDescription.Type
    object SecurityProfileId extends Subtype[String]
    type SecurityProfileId =
      zio.aws.connect.model.primitives.SecurityProfileId.Type
    object SecurityProfileName extends Subtype[String]
    type SecurityProfileName =
      zio.aws.connect.model.primitives.SecurityProfileName.Type
    object SecurityProfilePermission extends Subtype[String]
    type SecurityProfilePermission =
      zio.aws.connect.model.primitives.SecurityProfilePermission.Type
    object SecurityToken extends Subtype[String]
    type SecurityToken = zio.aws.connect.model.primitives.SecurityToken.Type
    object SnapshotVersion extends Subtype[String]
    type SnapshotVersion = zio.aws.connect.model.primitives.SnapshotVersion.Type
    object SourceApplicationName extends Subtype[String]
    type SourceApplicationName =
      zio.aws.connect.model.primitives.SourceApplicationName.Type
    object StreamingId extends Subtype[String]
    type StreamingId = zio.aws.connect.model.primitives.StreamingId.Type
    object SupportedMessagingContentType extends Subtype[String]
    type SupportedMessagingContentType =
      zio.aws.connect.model.primitives.SupportedMessagingContentType.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.connect.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.connect.model.primitives.TagValue.Type
    object TaskTemplateArn extends Subtype[String]
    type TaskTemplateArn = zio.aws.connect.model.primitives.TaskTemplateArn.Type
    object TaskTemplateDescription extends Subtype[String]
    type TaskTemplateDescription =
      zio.aws.connect.model.primitives.TaskTemplateDescription.Type
    object TaskTemplateFieldDescription extends Subtype[String]
    type TaskTemplateFieldDescription =
      zio.aws.connect.model.primitives.TaskTemplateFieldDescription.Type
    object TaskTemplateFieldName extends Subtype[String]
    type TaskTemplateFieldName =
      zio.aws.connect.model.primitives.TaskTemplateFieldName.Type
    object TaskTemplateFieldValue extends Subtype[String]
    type TaskTemplateFieldValue =
      zio.aws.connect.model.primitives.TaskTemplateFieldValue.Type
    object TaskTemplateId extends Subtype[String]
    type TaskTemplateId = zio.aws.connect.model.primitives.TaskTemplateId.Type
    object TaskTemplateName extends Subtype[String]
    type TaskTemplateName =
      zio.aws.connect.model.primitives.TaskTemplateName.Type
    object TaskTemplateSingleSelectOption extends Subtype[String]
    type TaskTemplateSingleSelectOption =
      zio.aws.connect.model.primitives.TaskTemplateSingleSelectOption.Type
    object ThresholdValue extends Subtype[Double]
    type ThresholdValue = zio.aws.connect.model.primitives.ThresholdValue.Type
    object TimeZone extends Subtype[String]
    type TimeZone = zio.aws.connect.model.primitives.TimeZone.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.connect.model.primitives.Timestamp.Type
    object TrafficDistributionGroupArn extends Subtype[String]
    type TrafficDistributionGroupArn =
      zio.aws.connect.model.primitives.TrafficDistributionGroupArn.Type
    object TrafficDistributionGroupId extends Subtype[String]
    type TrafficDistributionGroupId =
      zio.aws.connect.model.primitives.TrafficDistributionGroupId.Type
    object TrafficDistributionGroupIdOrArn extends Subtype[String]
    type TrafficDistributionGroupIdOrArn =
      zio.aws.connect.model.primitives.TrafficDistributionGroupIdOrArn.Type
    object URI extends Subtype[String]
    type URI = zio.aws.connect.model.primitives.URI.Type
    object UpdateAgentStatusDescription extends Subtype[String]
    type UpdateAgentStatusDescription =
      zio.aws.connect.model.primitives.UpdateAgentStatusDescription.Type
    object UpdateHoursOfOperationDescription extends Subtype[String]
    type UpdateHoursOfOperationDescription =
      zio.aws.connect.model.primitives.UpdateHoursOfOperationDescription.Type
    object UpdateQuickConnectDescription extends Subtype[String]
    type UpdateQuickConnectDescription =
      zio.aws.connect.model.primitives.UpdateQuickConnectDescription.Type
    object UseCaseId extends Subtype[String]
    type UseCaseId = zio.aws.connect.model.primitives.UseCaseId.Type
    object UserId extends Subtype[String]
    type UserId = zio.aws.connect.model.primitives.UserId.Type
    object Value extends Subtype[Double]
    type Value = zio.aws.connect.model.primitives.Value.Type
    object VocabularyContent extends Subtype[String]
    type VocabularyContent =
      zio.aws.connect.model.primitives.VocabularyContent.Type
    object VocabularyFailureReason extends Subtype[String]
    type VocabularyFailureReason =
      zio.aws.connect.model.primitives.VocabularyFailureReason.Type
    object VocabularyId extends Subtype[String]
    type VocabularyId = zio.aws.connect.model.primitives.VocabularyId.Type
    object VocabularyLastModifiedTime extends Subtype[Instant]
    type VocabularyLastModifiedTime =
      zio.aws.connect.model.primitives.VocabularyLastModifiedTime.Type
    object VocabularyName extends Subtype[String]
    type VocabularyName = zio.aws.connect.model.primitives.VocabularyName.Type
    object VocabularyNextToken extends Subtype[String]
    type VocabularyNextToken =
      zio.aws.connect.model.primitives.VocabularyNextToken.Type
  }
  type AgentContactReferenceList =
    List[zio.aws.connect.model.AgentContactReference]
  type AgentStatusSummaryList = List[zio.aws.connect.model.AgentStatusSummary]
  type AgentStatusTypes = List[zio.aws.connect.model.AgentStatusType]
  type Attributes = Map[AttributeName, AttributeValue]
  type AttributesList = List[zio.aws.connect.model.Attribute]
  type AvailableNumbersList = List[zio.aws.connect.model.AvailableNumberSummary]
  type ChannelToCountMap = Map[zio.aws.connect.model.Channel, IntegerCount]
  type Channels = List[zio.aws.connect.model.Channel]
  type ContactFlowModulesSummaryList =
    List[zio.aws.connect.model.ContactFlowModuleSummary]
  type ContactFlowSummaryList = List[zio.aws.connect.model.ContactFlowSummary]
  type ContactFlowTypes = List[zio.aws.connect.model.ContactFlowType]
  type ContactReferences = Map[ReferenceKey, zio.aws.connect.model.Reference]
  type ContactStates = List[zio.aws.connect.model.ContactState]
  type CurrentMetricDataCollections =
    List[zio.aws.connect.model.CurrentMetricData]
  type CurrentMetricResults = List[zio.aws.connect.model.CurrentMetricResult]
  type CurrentMetrics = List[zio.aws.connect.model.CurrentMetric]
  type DefaultVocabularyList = List[zio.aws.connect.model.DefaultVocabulary]
  type DistributionList = List[zio.aws.connect.model.Distribution]
  type FunctionArnsList = List[FunctionArn]
  type Groupings = List[zio.aws.connect.model.Grouping]
  type HierarchyGroupSummaryList =
    List[zio.aws.connect.model.HierarchyGroupSummary]
  type HistoricalMetricDataCollections =
    List[zio.aws.connect.model.HistoricalMetricData]
  type HistoricalMetricResults =
    List[zio.aws.connect.model.HistoricalMetricResult]
  type HistoricalMetrics = List[zio.aws.connect.model.HistoricalMetric]
  type HoursOfOperationConfigList =
    List[zio.aws.connect.model.HoursOfOperationConfig]
  type HoursOfOperationSummaryList =
    List[zio.aws.connect.model.HoursOfOperationSummary]
  type InstanceStorageConfigs =
    List[zio.aws.connect.model.InstanceStorageConfig]
  type InstanceSummaryList = List[zio.aws.connect.model.InstanceSummary]
  type IntegrationAssociationSummaryList =
    List[zio.aws.connect.model.IntegrationAssociationSummary]
  type InvisibleTaskTemplateFields =
    List[zio.aws.connect.model.InvisibleFieldInfo]
  type LexBotConfigList = List[zio.aws.connect.model.LexBotConfig]
  type LexBotsList = List[zio.aws.connect.model.LexBot]
  type ListPhoneNumbersSummaryList =
    List[zio.aws.connect.model.ListPhoneNumbersSummary]
  type MediaConcurrencies = List[zio.aws.connect.model.MediaConcurrency]
  type OriginsList = List[Origin]
  type PermissionsList = List[SecurityProfilePermission]
  type PhoneNumberCountryCodes =
    List[zio.aws.connect.model.PhoneNumberCountryCode]
  type PhoneNumberSummaryList = List[zio.aws.connect.model.PhoneNumberSummary]
  type PhoneNumberTypes = List[zio.aws.connect.model.PhoneNumberType]
  type PromptSummaryList = List[zio.aws.connect.model.PromptSummary]
  type QueueSearchConditionList =
    List[zio.aws.connect.model.QueueSearchCriteria]
  type QueueSearchSummaryList = List[zio.aws.connect.model.Queue]
  type QueueSummaryList = List[zio.aws.connect.model.QueueSummary]
  type QueueTypes = List[zio.aws.connect.model.QueueType]
  type Queues = List[QueueId]
  type QuickConnectSummaryList = List[zio.aws.connect.model.QuickConnectSummary]
  type QuickConnectTypes = List[zio.aws.connect.model.QuickConnectType]
  type QuickConnectsList = List[QuickConnectId]
  type ReadOnlyTaskTemplateFields =
    List[zio.aws.connect.model.ReadOnlyFieldInfo]
  type ReferenceSummaryList = List[zio.aws.connect.model.ReferenceSummary]
  type ReferenceTypes = List[zio.aws.connect.model.ReferenceType]
  type RequiredTaskTemplateFields =
    List[zio.aws.connect.model.RequiredFieldInfo]
  type RoutingProfileList = List[zio.aws.connect.model.RoutingProfile]
  type RoutingProfileQueueConfigList =
    List[zio.aws.connect.model.RoutingProfileQueueConfig]
  type RoutingProfileQueueConfigSummaryList =
    List[zio.aws.connect.model.RoutingProfileQueueConfigSummary]
  type RoutingProfileQueueReferenceList =
    List[zio.aws.connect.model.RoutingProfileQueueReference]
  type RoutingProfileSearchConditionList =
    List[zio.aws.connect.model.RoutingProfileSearchCriteria]
  type RoutingProfileSummaryList =
    List[zio.aws.connect.model.RoutingProfileSummary]
  type SecurityKeysList = List[zio.aws.connect.model.SecurityKey]
  type SecurityProfileIds = List[SecurityProfileId]
  type SecurityProfileSearchConditionList =
    List[zio.aws.connect.model.SecurityProfileSearchCriteria]
  type SecurityProfileSummaryList =
    List[zio.aws.connect.model.SecurityProfileSummary]
  type SecurityProfilesSearchSummaryList =
    List[zio.aws.connect.model.SecurityProfileSearchSummary]
  type SingleSelectOptions = List[TaskTemplateSingleSelectOption]
  type SupportedMessagingContentTypes = List[SupportedMessagingContentType]
  type TagAndConditionList = List[zio.aws.connect.model.TagCondition]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type TagOrConditionList = List[Iterable[zio.aws.connect.model.TagCondition]]
  type TaskTemplateDefaultFieldValueList =
    List[zio.aws.connect.model.TaskTemplateDefaultFieldValue]
  type TaskTemplateFields = List[zio.aws.connect.model.TaskTemplateField]
  type TaskTemplateList = List[zio.aws.connect.model.TaskTemplateMetadata]
  type TrafficDistributionGroupSummaryList =
    List[zio.aws.connect.model.TrafficDistributionGroupSummary]
  type UseCaseSummaryList = List[zio.aws.connect.model.UseCase]
  type UserDataList = List[zio.aws.connect.model.UserData]
  type UserSearchConditionList = List[zio.aws.connect.model.UserSearchCriteria]
  type UserSearchSummaryList = List[zio.aws.connect.model.UserSearchSummary]
  type UserSummaryList = List[zio.aws.connect.model.UserSummary]
  type VocabularySummaryList = List[zio.aws.connect.model.VocabularySummary]
}
