package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ActionSummary(actionType: zio.aws.connect.model.ActionType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ActionSummary = {
    import ActionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ActionSummary
      .builder()
      .actionType(actionType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ActionSummary.ReadOnly =
    zio.aws.connect.model.ActionSummary.wrap(buildAwsValue())
}
object ActionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ActionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ActionSummary =
      zio.aws.connect.model.ActionSummary(actionType)
    def actionType: zio.aws.connect.model.ActionType
    def getActionType: ZIO[Any, Nothing, zio.aws.connect.model.ActionType] =
      ZIO.succeed(actionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ActionSummary
  ) extends zio.aws.connect.model.ActionSummary.ReadOnly {
    override val actionType: zio.aws.connect.model.ActionType =
      zio.aws.connect.model.ActionType.wrap(impl.actionType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ActionSummary
  ): zio.aws.connect.model.ActionSummary.ReadOnly = new Wrapper(impl)
}
