package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait ActionType {
  def unwrap: software.amazon.awssdk.services.connect.model.ActionType
}
object ActionType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.ActionType
  ): zio.aws.connect.model.ActionType = value match {
    case software.amazon.awssdk.services.connect.model.ActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.ActionType.CREATE_TASK =>
      val r = CREATE_TASK
      r
    case software.amazon.awssdk.services.connect.model.ActionType.ASSIGN_CONTACT_CATEGORY =>
      val r = ASSIGN_CONTACT_CATEGORY
      r
    case software.amazon.awssdk.services.connect.model.ActionType.GENERATE_EVENTBRIDGE_EVENT =>
      val r = GENERATE_EVENTBRIDGE_EVENT
      r
    case software.amazon.awssdk.services.connect.model.ActionType.SEND_NOTIFICATION =>
      val r = SEND_NOTIFICATION
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ActionType =
      software.amazon.awssdk.services.connect.model.ActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_TASK extends zio.aws.connect.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ActionType =
      software.amazon.awssdk.services.connect.model.ActionType.CREATE_TASK
  }
  case object ASSIGN_CONTACT_CATEGORY extends zio.aws.connect.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ActionType =
      software.amazon.awssdk.services.connect.model.ActionType.ASSIGN_CONTACT_CATEGORY
  }
  case object GENERATE_EVENTBRIDGE_EVENT
      extends zio.aws.connect.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ActionType =
      software.amazon.awssdk.services.connect.model.ActionType.GENERATE_EVENTBRIDGE_EVENT
  }
  case object SEND_NOTIFICATION extends zio.aws.connect.model.ActionType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ActionType =
      software.amazon.awssdk.services.connect.model.ActionType.SEND_NOTIFICATION
  }
}
