package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{VersionNumber, ResourceId, InstanceId}
import scala.jdk.CollectionConverters._
final case class ActivateEvaluationFormRequest(
    instanceId: InstanceId,
    evaluationFormId: ResourceId,
    evaluationFormVersion: VersionNumber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ActivateEvaluationFormRequest = {
    import ActivateEvaluationFormRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ActivateEvaluationFormRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .evaluationFormId(ResourceId.unwrap(evaluationFormId): java.lang.String)
      .evaluationFormVersion(
        VersionNumber.unwrap(evaluationFormVersion): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ActivateEvaluationFormRequest.ReadOnly =
    zio.aws.connect.model.ActivateEvaluationFormRequest.wrap(buildAwsValue())
}
object ActivateEvaluationFormRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ActivateEvaluationFormRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ActivateEvaluationFormRequest =
      zio.aws.connect.model.ActivateEvaluationFormRequest(
        instanceId,
        evaluationFormId,
        evaluationFormVersion
      )
    def instanceId: InstanceId
    def evaluationFormId: ResourceId
    def evaluationFormVersion: VersionNumber
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getEvaluationFormId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationFormId)
    def getEvaluationFormVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(evaluationFormVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ActivateEvaluationFormRequest
  ) extends zio.aws.connect.model.ActivateEvaluationFormRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val evaluationFormId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationFormId())
    override val evaluationFormVersion: VersionNumber =
      zio.aws.connect.model.primitives
        .VersionNumber(impl.evaluationFormVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ActivateEvaluationFormRequest
  ): zio.aws.connect.model.ActivateEvaluationFormRequest.ReadOnly = new Wrapper(
    impl
  )
}
