package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait AgentAvailabilityTimer {
  def unwrap
      : software.amazon.awssdk.services.connect.model.AgentAvailabilityTimer
}
object AgentAvailabilityTimer {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.AgentAvailabilityTimer
  ): zio.aws.connect.model.AgentAvailabilityTimer = value match {
    case software.amazon.awssdk.services.connect.model.AgentAvailabilityTimer.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.AgentAvailabilityTimer.TIME_SINCE_LAST_ACTIVITY =>
      val r = TIME_SINCE_LAST_ACTIVITY
      r
    case software.amazon.awssdk.services.connect.model.AgentAvailabilityTimer.TIME_SINCE_LAST_INBOUND =>
      val r = TIME_SINCE_LAST_INBOUND
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.AgentAvailabilityTimer {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.AgentAvailabilityTimer =
      software.amazon.awssdk.services.connect.model.AgentAvailabilityTimer.UNKNOWN_TO_SDK_VERSION
  }
  case object TIME_SINCE_LAST_ACTIVITY
      extends zio.aws.connect.model.AgentAvailabilityTimer {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.AgentAvailabilityTimer =
      software.amazon.awssdk.services.connect.model.AgentAvailabilityTimer.TIME_SINCE_LAST_ACTIVITY
  }
  case object TIME_SINCE_LAST_INBOUND
      extends zio.aws.connect.model.AgentAvailabilityTimer {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.AgentAvailabilityTimer =
      software.amazon.awssdk.services.connect.model.AgentAvailabilityTimer.TIME_SINCE_LAST_INBOUND
  }
}
