package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AgentConfig(
    distributions: Iterable[zio.aws.connect.model.Distribution]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AgentConfig = {
    import AgentConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AgentConfig
      .builder()
      .distributions(distributions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AgentConfig.ReadOnly =
    zio.aws.connect.model.AgentConfig.wrap(buildAwsValue())
}
object AgentConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AgentConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AgentConfig =
      zio.aws.connect.model.AgentConfig(distributions.map { item =>
        item.asEditable
      })
    def distributions: List[zio.aws.connect.model.Distribution.ReadOnly]
    def getDistributions
        : ZIO[Any, Nothing, List[zio.aws.connect.model.Distribution.ReadOnly]] =
      ZIO.succeed(distributions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AgentConfig
  ) extends zio.aws.connect.model.AgentConfig.ReadOnly {
    override val distributions
        : List[zio.aws.connect.model.Distribution.ReadOnly] = impl
      .distributions()
      .asScala
      .map { item =>
        zio.aws.connect.model.Distribution.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AgentConfig
  ): zio.aws.connect.model.AgentConfig.ReadOnly = new Wrapper(impl)
}
