package zio.aws.connect.model
import zio.aws.connect.model.primitives.{AgentStatusName, ARN, Timestamp}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AgentStatusReference(
    statusStartTimestamp: Optional[Timestamp] = Optional.Absent,
    statusArn: Optional[ARN] = Optional.Absent,
    statusName: Optional[AgentStatusName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AgentStatusReference = {
    import AgentStatusReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AgentStatusReference
      .builder()
      .optionallyWith(
        statusStartTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.statusStartTimestamp)
      .optionallyWith(
        statusArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.statusArn)
      .optionallyWith(
        statusName.map(value => AgentStatusName.unwrap(value): java.lang.String)
      )(_.statusName)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AgentStatusReference.ReadOnly =
    zio.aws.connect.model.AgentStatusReference.wrap(buildAwsValue())
}
object AgentStatusReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AgentStatusReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AgentStatusReference =
      zio.aws.connect.model.AgentStatusReference(
        statusStartTimestamp.map(value => value),
        statusArn.map(value => value),
        statusName.map(value => value)
      )
    def statusStartTimestamp: Optional[Timestamp]
    def statusArn: Optional[ARN]
    def statusName: Optional[AgentStatusName]
    def getStatusStartTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("statusStartTimestamp", statusStartTimestamp)
    def getStatusArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("statusArn", statusArn)
    def getStatusName: ZIO[Any, AwsError, AgentStatusName] =
      AwsError.unwrapOptionField("statusName", statusName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AgentStatusReference
  ) extends zio.aws.connect.model.AgentStatusReference.ReadOnly {
    override val statusStartTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusStartTimestamp())
        .map(value => zio.aws.connect.model.primitives.Timestamp(value))
    override val statusArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.statusArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val statusName: Optional[AgentStatusName] = zio.aws.core.internal
      .optionalFromNullable(impl.statusName())
      .map(value => zio.aws.connect.model.primitives.AgentStatusName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AgentStatusReference
  ): zio.aws.connect.model.AgentStatusReference.ReadOnly = new Wrapper(impl)
}
