package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait AgentStatusType {
  def unwrap: software.amazon.awssdk.services.connect.model.AgentStatusType
}
object AgentStatusType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.AgentStatusType
  ): zio.aws.connect.model.AgentStatusType = value match {
    case software.amazon.awssdk.services.connect.model.AgentStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.AgentStatusType.ROUTABLE =>
      val r = ROUTABLE
      r
    case software.amazon.awssdk.services.connect.model.AgentStatusType.CUSTOM =>
      val r = CUSTOM
      r
    case software.amazon.awssdk.services.connect.model.AgentStatusType.OFFLINE =>
      val r = OFFLINE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.AgentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.AgentStatusType =
      software.amazon.awssdk.services.connect.model.AgentStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object ROUTABLE extends zio.aws.connect.model.AgentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.AgentStatusType =
      software.amazon.awssdk.services.connect.model.AgentStatusType.ROUTABLE
  }
  case object CUSTOM extends zio.aws.connect.model.AgentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.AgentStatusType =
      software.amazon.awssdk.services.connect.model.AgentStatusType.CUSTOM
  }
  case object OFFLINE extends zio.aws.connect.model.AgentStatusType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.AgentStatusType =
      software.amazon.awssdk.services.connect.model.AgentStatusType.OFFLINE
  }
}
