package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.InstanceId
import scala.jdk.CollectionConverters._
final case class AssociateInstanceStorageConfigRequest(
    instanceId: InstanceId,
    resourceType: zio.aws.connect.model.InstanceStorageResourceType,
    storageConfig: zio.aws.connect.model.InstanceStorageConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigRequest = {
    import AssociateInstanceStorageConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .resourceType(resourceType.unwrap)
      .storageConfig(storageConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.AssociateInstanceStorageConfigRequest.ReadOnly =
    zio.aws.connect.model.AssociateInstanceStorageConfigRequest
      .wrap(buildAwsValue())
}
object AssociateInstanceStorageConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.AssociateInstanceStorageConfigRequest =
      zio.aws.connect.model.AssociateInstanceStorageConfigRequest(
        instanceId,
        resourceType,
        storageConfig.asEditable
      )
    def instanceId: InstanceId
    def resourceType: zio.aws.connect.model.InstanceStorageResourceType
    def storageConfig: zio.aws.connect.model.InstanceStorageConfig.ReadOnly
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.connect.model.InstanceStorageResourceType] =
      ZIO.succeed(resourceType)
    def getStorageConfig: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.InstanceStorageConfig.ReadOnly
    ] = ZIO.succeed(storageConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigRequest
  ) extends zio.aws.connect.model.AssociateInstanceStorageConfigRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val resourceType
        : zio.aws.connect.model.InstanceStorageResourceType =
      zio.aws.connect.model.InstanceStorageResourceType
        .wrap(impl.resourceType())
    override val storageConfig
        : zio.aws.connect.model.InstanceStorageConfig.ReadOnly =
      zio.aws.connect.model.InstanceStorageConfig.wrap(impl.storageConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigRequest
  ): zio.aws.connect.model.AssociateInstanceStorageConfigRequest.ReadOnly =
    new Wrapper(impl)
}
