package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{FunctionArn, InstanceId}
import scala.jdk.CollectionConverters._
final case class AssociateLambdaFunctionRequest(
    instanceId: InstanceId,
    functionArn: FunctionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionRequest = {
    import AssociateLambdaFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .functionArn(FunctionArn.unwrap(functionArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.AssociateLambdaFunctionRequest.ReadOnly =
    zio.aws.connect.model.AssociateLambdaFunctionRequest.wrap(buildAwsValue())
}
object AssociateLambdaFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AssociateLambdaFunctionRequest =
      zio.aws.connect.model
        .AssociateLambdaFunctionRequest(instanceId, functionArn)
    def instanceId: InstanceId
    def functionArn: FunctionArn
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getFunctionArn: ZIO[Any, Nothing, FunctionArn] =
      ZIO.succeed(functionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionRequest
  ) extends zio.aws.connect.model.AssociateLambdaFunctionRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val functionArn: FunctionArn =
      zio.aws.connect.model.primitives.FunctionArn(impl.functionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionRequest
  ): zio.aws.connect.model.AssociateLambdaFunctionRequest.ReadOnly =
    new Wrapper(impl)
}
