package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{QuickConnectId, QueueId, InstanceId}
import scala.jdk.CollectionConverters._
final case class AssociateQueueQuickConnectsRequest(
    instanceId: InstanceId,
    queueId: QueueId,
    quickConnectIds: Iterable[QuickConnectId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsRequest = {
    import AssociateQueueQuickConnectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .quickConnectIds(quickConnectIds.map { item =>
        QuickConnectId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.AssociateQueueQuickConnectsRequest.ReadOnly =
    zio.aws.connect.model.AssociateQueueQuickConnectsRequest
      .wrap(buildAwsValue())
}
object AssociateQueueQuickConnectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AssociateQueueQuickConnectsRequest =
      zio.aws.connect.model.AssociateQueueQuickConnectsRequest(
        instanceId,
        queueId,
        quickConnectIds
      )
    def instanceId: InstanceId
    def queueId: QueueId
    def quickConnectIds: List[QuickConnectId]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
    def getQuickConnectIds: ZIO[Any, Nothing, List[QuickConnectId]] =
      ZIO.succeed(quickConnectIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsRequest
  ) extends zio.aws.connect.model.AssociateQueueQuickConnectsRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val queueId: QueueId =
      zio.aws.connect.model.primitives.QueueId(impl.queueId())
    override val quickConnectIds: List[QuickConnectId] = impl
      .quickConnectIds()
      .asScala
      .map { item =>
        zio.aws.connect.model.primitives.QuickConnectId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsRequest
  ): zio.aws.connect.model.AssociateQueueQuickConnectsRequest.ReadOnly =
    new Wrapper(impl)
}
