package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{RoutingProfileId, InstanceId}
import scala.jdk.CollectionConverters._
final case class AssociateRoutingProfileQueuesRequest(
    instanceId: InstanceId,
    routingProfileId: RoutingProfileId,
    queueConfigs: Iterable[zio.aws.connect.model.RoutingProfileQueueConfig]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesRequest = {
    import AssociateRoutingProfileQueuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .routingProfileId(
        RoutingProfileId.unwrap(routingProfileId): java.lang.String
      )
      .queueConfigs(queueConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.AssociateRoutingProfileQueuesRequest.ReadOnly =
    zio.aws.connect.model.AssociateRoutingProfileQueuesRequest
      .wrap(buildAwsValue())
}
object AssociateRoutingProfileQueuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AssociateRoutingProfileQueuesRequest =
      zio.aws.connect.model.AssociateRoutingProfileQueuesRequest(
        instanceId,
        routingProfileId,
        queueConfigs.map { item =>
          item.asEditable
        }
      )
    def instanceId: InstanceId
    def routingProfileId: RoutingProfileId
    def queueConfigs
        : List[zio.aws.connect.model.RoutingProfileQueueConfig.ReadOnly]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getRoutingProfileId: ZIO[Any, Nothing, RoutingProfileId] =
      ZIO.succeed(routingProfileId)
    def getQueueConfigs: ZIO[Any, Nothing, List[
      zio.aws.connect.model.RoutingProfileQueueConfig.ReadOnly
    ]] = ZIO.succeed(queueConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesRequest
  ) extends zio.aws.connect.model.AssociateRoutingProfileQueuesRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val routingProfileId: RoutingProfileId =
      zio.aws.connect.model.primitives.RoutingProfileId(impl.routingProfileId())
    override val queueConfigs
        : List[zio.aws.connect.model.RoutingProfileQueueConfig.ReadOnly] = impl
      .queueConfigs()
      .asScala
      .map { item =>
        zio.aws.connect.model.RoutingProfileQueueConfig.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesRequest
  ): zio.aws.connect.model.AssociateRoutingProfileQueuesRequest.ReadOnly =
    new Wrapper(impl)
}
