package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.AssociationId
import scala.jdk.CollectionConverters._
final case class AssociateSecurityKeyResponse(
    associationId: Optional[AssociationId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.AssociateSecurityKeyResponse = {
    import AssociateSecurityKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.AssociateSecurityKeyResponse
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.AssociateSecurityKeyResponse.ReadOnly =
    zio.aws.connect.model.AssociateSecurityKeyResponse.wrap(buildAwsValue())
}
object AssociateSecurityKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.AssociateSecurityKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.AssociateSecurityKeyResponse =
      zio.aws.connect.model
        .AssociateSecurityKeyResponse(associationId.map(value => value))
    def associationId: Optional[AssociationId]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.AssociateSecurityKeyResponse
  ) extends zio.aws.connect.model.AssociateSecurityKeyResponse.ReadOnly {
    override val associationId: Optional[AssociationId] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => zio.aws.connect.model.primitives.AssociationId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.AssociateSecurityKeyResponse
  ): zio.aws.connect.model.AssociateSecurityKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
